/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.ExpressionList;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
public final class Block
extends ExpressionList {
    int blockCloseOffset = Integer.MIN_VALUE;

    Block() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.BLOCK;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return RTerminal.BLOCK_OPEN;
    }

    public int getBlockCloseOffset() {
        return this.blockCloseOffset;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.BLOCK == element.getNodeType();
    }

    final void updateOffsets() {
        if (this.blockCloseOffset != Integer.MIN_VALUE) {
            this.doSetEndOffset(this.blockCloseOffset + 1);
        } else {
            int count = this.getChildCount();
            if (count > 0) {
                this.doSetEndOffset(this.getChild(count - 1).getEndOffset());
            } else {
                this.doSetEndOffset(this.getStartOffset() + 1);
            }
        }
    }
}

