/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LaunchShortcutUtil {
    public static final String TOGGLE_ECHO_COMMAND_ID = "org.eclipse.statet.r.commands.ToggleRunEcho";

    public static String getContentTypeId(IFile file) {
        IContentType contentType = IDE.guessContentType((IFile)file);
        return contentType != null ? contentType.getId() : null;
    }

    public static String getContentTypeId(URI uri) {
        String fileName = URIUtil.lastSegment((URI)uri);
        if (fileName != null) {
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
            return contentType != null ? contentType.getId() : null;
        }
        return null;
    }

    public static List<String> getCodeLines(IFile file) throws CoreException {
        InputStream input = null;
        try {
            Charset charset;
            try {
                input = file.getContents();
                charset = Charset.forName(file.getCharset());
            }
            catch (CoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, (Throwable)e));
            }
            try {
                int n;
                BufferedReader reader = IOUtils.newBufferedStreamContentReader((InputStream)input, (Charset)charset);
                StringBuilder buffer = new StringBuilder();
                char[] readBuffer = new char[2048];
                while ((n = reader.read(readBuffer)) > 0) {
                    buffer.append(readBuffer, 0, n);
                }
                IContentType contentType = IDE.getContentType((IFile)file);
                ICodeSubmitContentHandler handler = RCodeLaunching.getCodeSubmitContentHandler(contentType != null ? contentType.getId() : null);
                Document document = new Document(buffer.toString());
                handler.setup((IDocument)document);
                List<String> list = handler.getCodeLines((IDocument)document);
                return list;
            }
            catch (IOException | CoreException | BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, e));
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getSelectedCodeLines(ExecutionEvent event) throws CoreException {
        try {
            ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
            IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
            ISelection iSelection = selection;
            if (iSelection instanceof ITextSelection) {
                SourceEditor editor;
                String code;
                void textSelection;
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
                if (textSelection.getLength() > 0 && (code = textSelection.getText()) != null) {
                    return StringUtils.linesToList((String)code);
                }
                IDocument document = null;
                IWorkbenchPart iWorkbenchPart = workbenchPart;
                if (iWorkbenchPart instanceof ITextEditor) {
                    void editor2;
                    ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
                    ITextEditor cfr_ignored_1 = (ITextEditor)iWorkbenchPart;
                    IDocumentProvider documentProvider = editor2.getDocumentProvider();
                    if (documentProvider != null) {
                        document = documentProvider.getDocument((Object)editor2.getEditorInput());
                    }
                }
                if (document == null && (editor = (SourceEditor)workbenchPart.getAdapter(SourceEditor.class)) != null) {
                    document = editor.getViewer().getDocument();
                }
                if (document != null) {
                    ArrayList<String> lines = new ArrayList<String>(document.getNumberOfLines(textSelection.getOffset(), textSelection.getLength()));
                    if (textSelection.getLength() > 0) {
                        TextUtil.addLines((IDocument)document, (int)textSelection.getOffset(), (int)textSelection.getLength(), lines);
                    } else {
                        int line = document.getLineOfOffset(textSelection.getOffset());
                        IRegion lineInformation = document.getLineInformation(line);
                        lines.add(document.get(lineInformation.getOffset(), lineInformation.getLength()));
                    }
                    return lines;
                }
            }
            return null;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, (Throwable)e));
        }
    }

    public static Object getFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI();
        }
        return null;
    }

    public static IStatus createUnsupported() {
        return new Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCode_info_NotSupported_message);
    }

    public static void handleUnsupportedExecution(ExecutionEvent executionEvent) {
        LTKWorkbenchUIUtil.indicateStatus((IStatus)LaunchShortcutUtil.createUnsupported(), (ExecutionEvent)executionEvent);
    }

    public static void handleRLaunchException(Throwable e, String defaultMessage, ExecutionEvent executionEvent) {
        Status status = new Status(4, "org.eclipse.statet.r.ui", 0, defaultMessage, e);
        StatusManager.getManager().handle((IStatus)status);
        if (e instanceof CoreException) {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)((CoreException)e).getStatus(), (ExecutionEvent)executionEvent);
        } else {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)status, (ExecutionEvent)executionEvent);
        }
    }

    private LaunchShortcutUtil() {
    }
}

