/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.util;

import java.util.ArrayList;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.util.RElementInputContentProvider;
import org.eclipse.statet.rj.data.RObject;

@NonNullByDefault
public class RElementInputUtils {
    public static void addDoubleClickExpansion(AbstractTreeViewer viewer) {
        viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(viewer));
    }

    public static @Nullable RElementName getRElementName(TreePath treePath, ITreeSelection selection) {
        if (selection instanceof ElementNameProvider) {
            return (RElementName)((ElementNameProvider)selection).getElementName((Object)treePath);
        }
        if (treePath.getSegmentCount() == 0) {
            return null;
        }
        ArrayList names = new ArrayList(treePath.getSegmentCount() + 4);
        int segmentIdx = 0;
        while (segmentIdx < treePath.getSegmentCount()) {
            Object segment;
            if ((segment = treePath.getSegment(segmentIdx++)) instanceof ElementPartition) continue;
            CombinedRElement rElement = RElementInputContentProvider.getCombinedRElement(segment);
            if (rElement == null) {
                return null;
            }
            RElementName.addSegments(names, (RElementName)rElement.getElementName());
        }
        return RElementName.create(names);
    }

    private RElementInputUtils() {
    }

    public static class DoubleClickListener
    implements IDoubleClickListener {
        private final AbstractTreeViewer viewer;

        public DoubleClickListener(AbstractTreeViewer viewer) {
            this.viewer = viewer;
        }

        /*
         * WARNING - void declaration
         */
        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() != 1) {
                return;
            }
            Object element = selection.getFirstElement();
            Object object = element;
            if (object instanceof RObject) {
                void object2;
                RObject rObject = (RObject)object;
                RObject cfr_ignored_0 = (RObject)object;
                switch (object2.getRObjectType()) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 14: {
                        this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
                        break;
                    }
                }
            }
        }
    }
}

