/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee10;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.http.HttpHeaderUtils;
import org.eclipse.statet.internal.rhelp.core.server.ServerApi;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.DataStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rhelp.core.http.CustomMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee10.ResourceHandler;
import org.eclipse.statet.rhelp.core.http.ee10.ServletMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee10.SimpleResourceHandler;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public abstract class RHelpApi1Servlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_RENV_ID = "rhelp.renv.id";
    private static final String ATTR_RENV_RESOLVED = "rhelp.renv.resolved";
    private static final String ATTR_RENV_HELP = "rhelp.renv.help";
    private static final String ATTR_RENV_CONFIG = "rhelp.renv.config";
    private static final MediaTypeProvider API_MEDIA_TYPE_PROVIDER;
    private RHelpManager rHelpManager;
    private ResourceHandler resourceHandler;

    static {
        CustomMediaTypeProvider apiMediaTypes = new CustomMediaTypeProvider();
        apiMediaTypes.addExt("ser", "application/x.org.eclipse.statet.rhelp-ds");
        API_MEDIA_TYPE_PROVIDER = apiMediaTypes;
    }

    private static String getEnvId(HttpServletRequest req) {
        return (String)req.getAttribute(ATTR_RENV_ID);
    }

    private static REnv getEnv(HttpServletRequest req) {
        return (REnv)req.getAttribute(ATTR_RENV_RESOLVED);
    }

    private static REnvHelpImpl getEnvHelp(HttpServletRequest req) {
        return (REnvHelpImpl)req.getAttribute(ATTR_RENV_HELP);
    }

    protected void init(RHelpManager rHelpManager, @Nullable ResourceHandler resourceHandler) {
        this.rHelpManager = rHelpManager;
        this.resourceHandler = resourceHandler != null ? resourceHandler : new SimpleResourceHandler(new ServletMediaTypeProvider(this.getServletContext()));
        this.resourceHandler.setSpecialMediaTypes(API_MEDIA_TYPE_PROVIDER);
        this.resourceHandler.setCacheControl("max-age=100, must-revalidate");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        try {
            block28: {
                ServerApi.RequestInfo info;
                if (path == null || (info = ServerApi.extractRequestInfo(path)) == null) break block28;
                if (!this.checkREnv(info.rEnvId, req, resp)) {
                    return;
                }
                switch (info.segments[0]) {
                    case "stamp": {
                        if (info.segmentCount != 1) break;
                        this.processStamp(req, resp);
                        return;
                    }
                    case "basic-data": {
                        if (info.segmentCount != 1) break;
                        this.processBasicData(req, resp);
                        return;
                    }
                    case "pkgs": {
                        if (info.segmentCount < 2) break;
                        this.processPkgs(info, req, resp);
                        return;
                    }
                    case "pages": {
                        if (info.segmentCount != 1) break;
                        this.processPages(req, resp);
                        return;
                    }
                }
            }
            resp.sendError(400);
            return;
        }
        catch (StatusException e) {
            resp.sendError(500, "R Help Server Error - " + e.getMessage());
            return;
        }
        finally {
            REnvHelp help = (REnvHelp)req.getAttribute(ATTR_RENV_HELP);
            if (help != null) {
                help.unlock();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        try {
            block16: {
                ServerApi.RequestInfo info;
                if (path == null || (info = ServerApi.extractRequestInfo(path)) == null) break block16;
                if (!this.checkREnv(info.rEnvId, req, resp)) {
                    return;
                }
                switch (info.segments[0]) {
                    case "search": {
                        if (info.segmentCount != 1) break;
                        this.processSearch(req, resp);
                        return;
                    }
                }
            }
            resp.sendError(400);
            return;
        }
        catch (StatusException e) {
            resp.sendError(500, "R Help Server Error - " + e.getMessage());
            return;
        }
        finally {
            REnvHelp help = (REnvHelp)req.getAttribute(ATTR_RENV_HELP);
            if (help != null) {
                help.unlock();
            }
        }
    }

    private boolean checkREnv(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpConfiguration config;
        REnv rEnv = this.rHelpManager.getREnv(id);
        if (rEnv != null) {
            rEnv = rEnv.resolve();
        }
        if (rEnv != null && (config = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class)) != null) {
            req.setAttribute(ATTR_RENV_ID, (Object)id);
            req.setAttribute(ATTR_RENV_RESOLVED, (Object)rEnv);
            REnvHelp help = this.rHelpManager.getHelp(rEnv);
            if (help != null) {
                req.setAttribute(ATTR_RENV_HELP, (Object)help);
                req.setAttribute(ATTR_RENV_CONFIG, (Object)config);
                return true;
            }
            resp.sendError(404, "Not Found - The R library of the requested R environment <code>" + rEnv.getName() + "</code> " + "is not yet indexed. Please retry later.");
            return false;
        }
        String message = id.startsWith("default-") ? "The requested default R environment is missing." : "The requested R environment doesn't exist.";
        resp.sendError(404, "Not Found - " + message);
        return false;
    }

    private void processStamp(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        REnvHelpImpl help = RHelpApi1Servlet.getEnvHelp(req);
        resp.setContentType("application/x.org.eclipse.statet.rhelp-ds");
        Throwable throwable = null;
        Object var5_6 = null;
        try (ServletOutputStream out = resp.getOutputStream();){
            out.write(DataStream.encodeLong((long)help.getStamp()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected int checkAcceptDS(HttpServletRequest req) throws ServletException {
        List<HttpHeaderUtils.MediaTypeEntry> entries = RHelpApi1Servlet.readAcceptHeaderEntries(req, (type, subtype) -> type.equals("application") && subtype.equals("x.org.eclipse.statet.rhelp-ds"));
        return HttpHeaderUtils.findFirstValid(entries, "ser", v -> v == 12);
    }

    private void processBasicData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int serVersion;
        Matcher matcher;
        REnvHelpConfiguration config = (REnvHelpConfiguration)req.getAttribute(ATTR_RENV_CONFIG);
        String eTag = req.getHeader("If-None-Match");
        if (eTag != null && (matcher = ServerApi.ETAG_PATTERN.matcher(eTag)).matches()) {
            try {
                long stamp = Long.parseUnsignedLong(matcher.group(1));
                if (stamp == RHelpApi1Servlet.getEnvHelp(req).getStamp()) {
                    resp.setStatus(304);
                    return;
                }
            }
            catch (NumberFormatException stamp) {
                // empty catch block
            }
        }
        if ((serVersion = this.checkAcceptDS(req)) < 0) {
            resp.sendError(406);
            return;
        }
        Path file = SerUtil.getBasicDataFilePath(config);
        if (file != null && Files.isRegularFile(file, new LinkOption[0])) {
            this.resourceHandler.doGet(file, req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void processPkgs(ServerApi.RequestInfo info, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, StatusException {
        block9: {
            REnvHelpImpl help = RHelpApi1Servlet.getEnvHelp(req);
            if (info.segmentCount < 3) break block9;
            switch (info.segments[2]) {
                case "pages": {
                    RPkgHelp pkgHelp = help.getPkgHelp(info.segments[1]);
                    if (pkgHelp == null) {
                        resp.sendError(404);
                        return;
                    }
                    if (info.segmentCount == 4) {
                        this.processPkgPage(pkgHelp, info.segments[3], req, resp);
                        return;
                    }
                    this.processPkgPages(pkgHelp, req, resp);
                    return;
                }
            }
        }
        resp.sendError(400);
    }

    private void processPkgPages(RPkgHelp pkgHelp, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RHelpPage page;
        String topic = req.getParameter("topic");
        ImList pages = topic != null ? ((page = pkgHelp.getPageForTopic(topic)) != null ? ImCollections.newList((Object)page) : ImCollections.emptyList()) : pkgHelp.getPages();
        resp.setContentType("application/x.org.eclipse.statet.rhelp-ds");
        Throwable throwable = null;
        Object var7_8 = null;
        try (DataStream out = DataStream.get((OutputStream)resp.getOutputStream());){
            int n = pages.size();
            out.writeInt(n);
            int i = 0;
            while (i < n) {
                RHelpPage page2 = (RHelpPage)pages.get(i);
                out.writeString(page2.getName());
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void processPkgPage(RPkgHelp pkgHelp, String pageName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, StatusException {
        String queryString;
        REnvHelpImpl help = RHelpApi1Servlet.getEnvHelp(req);
        String html = help.getHtmlPage(pkgHelp, pageName, queryString = req.getParameter("qs"));
        if (html == null) {
            resp.sendError(404);
            return;
        }
        resp.setContentType("application/x.org.eclipse.statet.rhelp-ds");
        Throwable throwable = null;
        Object var9_10 = null;
        try (DataStream out = DataStream.get((OutputStream)resp.getOutputStream());){
            out.writeString(html);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void processPages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, StatusException {
        REnvHelpImpl help = RHelpApi1Servlet.getEnvHelp(req);
        String topic = req.getParameter("topic");
        if (topic != null) {
            List<RHelpPage> pages = help.getPagesForTopic(topic, null);
            resp.setContentType("application/x.org.eclipse.statet.rhelp-ds");
            Throwable throwable = null;
            Object var7_8 = null;
            try (DataStream out = DataStream.get((OutputStream)resp.getOutputStream());){
                int n = pages.size();
                out.writeInt(n);
                int i = 0;
                while (i < n) {
                    RHelpPage page = pages.get(i);
                    out.writeString(page.getPackage().getName());
                    out.writeString(page.getName());
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private @Nullable RHelpSearchQuery readRHelpSearchQuery(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getContentType() != null && req.getContentType().equals("application/x.org.eclipse.statet.rhelp-ds")) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DataStream in = DataStream.get((InputStream)req.getInputStream());){
                int searchType = in.readInt();
                String searchString = in.readNonNullString();
                ImList fields = ImCollections.newList((Object[])in.readNonNullStringArray());
                ImList keywords = ImCollections.newList((Object[])in.readNonNullStringArray());
                ImList packages = ImCollections.newList((Object[])in.readNonNullStringArray());
                return new RHelpSearchQuery(searchType, searchString, (List<String>)fields, (List<String>)keywords, (List<String>)packages, RHelpApi1Servlet.getEnv(req));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        resp.sendError(400, "Bad Request - Unsupported search query: 'ContentType'");
        return null;
    }

    private int readIntParam(HttpServletRequest req, String name, int defaultValue) {
        String s = req.getParameter(name);
        if (s != null) {
            try {
                int value = Integer.parseInt(s);
                if (value >= 0) {
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1;
        }
        return defaultValue;
    }

    private void processSearch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, StatusException {
        REnvHelpImpl help = RHelpApi1Servlet.getEnvHelp(req);
        RHelpSearchQuery searchQuery = this.readRHelpSearchQuery(req, resp);
        if (searchQuery == null) {
            return;
        }
        try {
            searchQuery.validate();
        }
        catch (StatusException e) {
            resp.sendError(400, "Bad Request - Invalid search query: " + e.getMessage());
            return;
        }
        final int maxFragments = this.readIntParam(req, "maxFragments", 10);
        if (maxFragments == -1) {
            resp.sendError(400, "Bad Request - Invalid param 'maxFragments'");
            return;
        }
        resp.setContentType("application/x.org.eclipse.statet.rhelp-ds");
        resp.flushBuffer();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (final DataStream out = DataStream.get((OutputStream)resp.getOutputStream());){
                help.search(searchQuery, new RHelpSearchRequestor(){

                    @Override
                    public int getMaxFragments() {
                        return maxFragments;
                    }

                    @Override
                    public void matchFound(RHelpSearchMatch match) {
                        try {
                            out.writeByte((byte)1);
                            RHelpPage page = match.getPage();
                            out.writeString(page.getPackage().getName());
                            out.writeString(page.getName());
                            out.writeFloat(match.getScore());
                            out.writeInt(match.getMatchCount());
                            if (match.getMatchCount() >= 0) {
                                RHelpSearchMatch.MatchFragment[] fragments = (RHelpSearchMatch.MatchFragment[])ObjectUtils.nonNullAssert((Object)match.getBestFragments());
                                int nFragments = fragments.length;
                                out.writeInt(nFragments);
                                int i = 0;
                                while (i < nFragments) {
                                    RHelpSearchMatch.MatchFragment fragment = fragments[i];
                                    out.writeString(fragment.getField());
                                    out.writeString(fragment.getText());
                                    ++i;
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new WrappedIOException(e);
                        }
                    }
                });
                out.writeInt(0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }

    private static List<HttpHeaderUtils.MediaTypeEntry> readAcceptHeaderEntries(HttpServletRequest req, @Nullable BiPredicate<String, String> filter) throws ServletException {
        try {
            return HttpHeaderUtils.readAcceptEntries(req.getHeaders("Accept"), filter);
        }
        catch (HttpHeaderUtils.ParseException e) {
            throw new ServletException("Failed to read Accept header of request.", (Throwable)e);
        }
    }

    private static class WrappedIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedIOException(IOException cause) {
            super(cause);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

