/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.RandomAccess;
import org.eclipse.statet.jcommons.collections.SortedListSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class SortedArraySet<E>
extends AbstractList<E>
implements SortedListSet<E>,
RandomAccess {
    private final Class<E> typeClass;
    protected final @Nullable Comparator<? super E> comparator;
    private E[] array;
    private int size;

    public SortedArraySet(E[] array, @Nullable Comparator<? super E> comparator) {
        this.typeClass = ObjectUtils.nonNullAssert(array.getClass().getComponentType());
        if (comparator == null && !Comparable.class.isAssignableFrom(this.typeClass)) {
            throw new NullPointerException("comparator");
        }
        this.comparator = comparator;
        this.array = array;
        this.size = array.length;
    }

    public SortedArraySet(E[] array, int size, @Nullable Comparator<? super E> comparator) {
        this.typeClass = ObjectUtils.nonNullAssert(array.getClass().getComponentType());
        if (comparator == null && !Comparable.class.isAssignableFrom(this.typeClass)) {
            throw new NullPointerException("comparator");
        }
        if (size < 0 || size > array.length) {
            throw new IllegalArgumentException("size= " + size);
        }
        this.comparator = comparator;
        this.array = array;
        this.size = size;
    }

    @Override
    public @Nullable Comparator<? super E> getComparator() {
        return this.comparator;
    }

    protected final void checkType(Object o) {
        this.typeClass.cast(ObjectUtils.nonNullAssert(o));
    }

    protected final void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index + ", size= " + this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.array.length < minCapacity) {
            ++this.modCount;
            Object[] newArray = (Object[])Array.newInstance(this.typeClass, Math.max(this.array.length * 3 / 2 + 1, minCapacity));
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public void trimToSize() {
        int l = this.size;
        if (this.array.length != l) {
            ++this.modCount;
            Object[] newArray = (Object[])Array.newInstance(this.typeClass, l);
            System.arraycopy(this.array, 0, newArray, 0, l);
            this.array = newArray;
        }
    }

    protected final E[] array() {
        return this.array;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    protected final int compare(E element1, E element2) {
        return this.comparator != null ? this.compare(element1, element2) : ((Comparable)element1).compareTo(element2);
    }

    protected final int binarySearch(int start, int end, E element) {
        return this.comparator != null ? this.binarySearchComparator(this.array, start, end, element) : this.binarySearchComparable(this.array, start, end, element);
    }

    protected final int binarySearchComparator(E[] a, int begin, int end, E element) {
        --end;
        while (begin <= end) {
            int i = begin + end >>> 1;
            int d = this.comparator.compare(a[i], element);
            if (d < 0) {
                begin = i + 1;
                continue;
            }
            if (d > 0) {
                end = i - 1;
                continue;
            }
            return i;
        }
        return -(begin + 1);
    }

    protected final int binarySearchComparable(E[] a, int begin, int end, E element) {
        --end;
        while (begin <= end) {
            int i = begin + end >>> 1;
            int d = ((Comparable)a[i]).compareTo(element);
            if (d < 0) {
                begin = i + 1;
                continue;
            }
            if (d > 0) {
                end = i - 1;
                continue;
            }
            return i;
        }
        return -(begin + 1);
    }

    @Override
    public int indexOfE(@NonNull E element) {
        this.checkType(element);
        return this.binarySearch(0, this.size, element);
    }

    @Override
    public final int indexOf(@NonNull Object o) {
        int index = this.indexOfE(o);
        return index >= 0 ? index : -1;
    }

    @Override
    public final int lastIndexOf(@NonNull Object o) {
        int index = this.indexOfE(o);
        return index >= 0 ? index : -1;
    }

    @Override
    public final boolean contains(@NonNull Object o) {
        return this.indexOfE(o) >= 0;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    protected final int addIndex(int index, E element) {
        if (index >= 0) {
            this.array[index] = element;
            return -(index + 1);
        }
        ++this.modCount;
        this.ensureCapacity(this.size + 1);
        index = -(index + 1);
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = element;
        ++this.size;
        return index;
    }

    @Override
    public int addE(@NonNull E element) {
        return this.addIndex(this.indexOfE(element), element);
    }

    public int addE(int startIndex, @NonNull E element) {
        this.checkType(element);
        if (startIndex < 0 || startIndex > this.size) {
            throw new IndexOutOfBoundsException("startIndex= " + startIndex + ", size= " + this.size);
        }
        int index = this.binarySearch(startIndex > 0 ? startIndex - 1 : startIndex, this.size, element);
        if (index >= 0 ? index < startIndex : -(index + 1) < startIndex) {
            throw new IllegalArgumentException("Index of element < startIndex: startIndex= " + startIndex);
        }
        return this.addIndex(index, element);
    }

    @Override
    public final boolean add(@NonNull E element) {
        return this.addE(element) >= 0;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        if (c instanceof SortedListSet && this.comparator == ((SortedListSet)c).getComparator()) {
            int index = 0;
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                if ((index = this.addE(index, iter.next())) >= 0) {
                    modified = true;
                    ++index;
                    continue;
                }
                index = -(index + 1);
            }
        } else {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                if (this.addE(iter.next()) < 0) continue;
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    public void addAllE(int index, E[] elements, int offset, int length) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index + ", size= " + this.size);
        }
        ++this.modCount;
        this.ensureCapacity(this.size + length);
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + length, this.size - index);
        }
        System.arraycopy(elements, offset, this.array, index, length);
        this.size += length;
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        E previous = this.array[index];
        if (this.compare(previous, element) == 0) {
            ++this.modCount;
            this.array[index] = element;
            return previous;
        }
        throw new IllegalArgumentException();
    }

    private void removeIndex(int index) {
        ++this.modCount;
        if (index + 1 < this.size) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - (index + 1));
        }
        this.array[--this.size] = null;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        if (n > 0) {
            ++this.modCount;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, n);
            Arrays.fill(this.array, this.size - n, this.size, null);
            this.size -= n;
        }
    }

    @Override
    public int removeE(@NonNull E element) {
        int index = this.indexOfE(element);
        if (index >= 0) {
            this.removeIndex(index);
            return index;
        }
        return index;
    }

    @Override
    public final boolean remove(@NonNull Object o) {
        return this.removeE(o) >= 0;
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        E previous = this.array[index];
        this.removeIndex(index);
        return previous;
    }

    @Override
    public void clear() {
        ++this.modCount;
        int i = 0;
        while (i < this.size) {
            this.array[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public SortedListSet<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > this.size || toIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        return new SubList(fromIndex, toIndex - fromIndex);
    }

    @Override
    public @NonNull Object[] toArray() {
        Object[] a = new Object[this.size];
        System.arraycopy(this.array, 0, a, 0, a.length);
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = this.size;
        if (a.length < s) {
            return Arrays.copyOf(this.array, s, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, s);
        if (a.length > s) {
            a[s] = null;
        }
        return a;
    }

    protected class SubList
    extends AbstractList<E>
    implements SortedListSet<E>,
    RandomAccess {
        private int expectedModCount;
        private final int offset;
        private int size;

        public SubList(int offset, int size) {
            this.expectedModCount = SortedArraySet.this.modCount;
            this.offset = offset;
            this.size = size;
        }

        protected final void checkModification() {
            if (this.expectedModCount != SortedArraySet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        protected final void checkSubIndex(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("index= " + index + ", size= " + this.size);
            }
        }

        @Override
        public final @Nullable Comparator<? super E> getComparator() {
            return SortedArraySet.this.comparator;
        }

        protected final int offset() {
            return this.offset;
        }

        @Override
        public final int size() {
            this.checkModification();
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            this.checkModification();
            return this.size == 0;
        }

        protected int superIndexOfE(@NonNull E element) {
            SortedArraySet.this.checkType(element);
            this.checkModification();
            return SortedArraySet.this.binarySearch(this.offset, this.offset + this.size, element);
        }

        protected int superIndexOfEChecked(@NonNull E element) {
            SortedArraySet.this.checkType(element);
            this.checkModification();
            int toIndex = this.offset + this.size;
            int index = SortedArraySet.this.binarySearch(this.offset > 0 ? this.offset - 1 : this.offset, toIndex < SortedArraySet.this.size ? toIndex + 1 : toIndex, element);
            if (index >= 0 ? index < this.offset || index > toIndex : -(index + 1) < this.offset || -(index + 1) > toIndex) {
                throw new IllegalArgumentException("Outside of subList: e= " + element);
            }
            return index;
        }

        @Override
        public int indexOfE(@NonNull E element) {
            int index = this.superIndexOfE(element);
            return index >= 0 ? index - this.offset : index + this.offset;
        }

        @Override
        public final int indexOf(@NonNull Object o) {
            int index = this.indexOfE(o);
            return index >= 0 ? index : -1;
        }

        @Override
        public final int lastIndexOf(@NonNull Object o) {
            int index = this.indexOfE(o);
            return index >= 0 ? index : -1;
        }

        @Override
        public final boolean contains(@NonNull Object o) {
            return this.superIndexOfE(o) >= 0;
        }

        protected final int addSuperIndex(int index, @NonNull E element) {
            if (index >= 0) {
                SortedArraySet.this.array[index] = element;
                return -(index - this.offset + 1);
            }
            ++this.modCount;
            SortedArraySet.this.addIndex(index, element);
            this.expectedModCount = SortedArraySet.this.modCount;
            ++this.size;
            return -(index + this.offset + 1);
        }

        @Override
        public int addE(@NonNull E element) {
            return this.addSuperIndex(this.superIndexOfEChecked(element), element);
        }

        public int addE(int startIndex, @NonNull E element) {
            SortedArraySet.this.checkType(element);
            if (startIndex < 0 || startIndex > this.size) {
                throw new IndexOutOfBoundsException("startIndex= " + startIndex + ", size= " + this.size);
            }
            this.checkModification();
            int toIndex = (startIndex += this.offset) + this.size;
            int index = SortedArraySet.this.binarySearch(startIndex > 0 ? startIndex - 1 : startIndex, toIndex < SortedArraySet.this.size ? toIndex + 1 : toIndex, element);
            if (index >= 0 ? index < startIndex : -(index + 1) < startIndex) {
                throw new IllegalArgumentException("Element < startIndex: startIndex= " + startIndex);
            }
            if (index >= 0 ? index > toIndex : -(index + 1) > toIndex) {
                throw new IllegalArgumentException("Element outside of subList: e= " + element);
            }
            return this.addSuperIndex(index, element);
        }

        @Override
        public final boolean add(@NonNull E element) {
            return this.addE(element) >= 0;
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (c.isEmpty()) {
                return false;
            }
            boolean modified = false;
            if (c instanceof SortedListSet && SortedArraySet.this.comparator == ((SortedListSet)c).getComparator()) {
                int index = 0;
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    if ((index = this.addE(index, iter.next())) >= 0) {
                        modified = true;
                        ++index;
                        continue;
                    }
                    index = -(index + 1);
                }
            } else {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    if (this.addE(iter.next()) < 0) continue;
                    modified = true;
                }
            }
            return modified;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull E set(int index, @NonNull E element) {
            this.checkSubIndex(index);
            Object previous = SortedArraySet.this.array[index += this.offset];
            if (SortedArraySet.this.compare(previous, element) == 0) {
                ++this.modCount;
                SortedArraySet.this.array[index] = element;
                return previous;
            }
            throw new IllegalArgumentException();
        }

        private void removeSuperIndex(int index) {
            ++this.modCount;
            SortedArraySet.this.removeIndex(index);
            this.expectedModCount = SortedArraySet.this.modCount;
            --this.size;
        }

        @Override
        public int removeE(@NonNull E element) {
            int index = this.superIndexOfE(element);
            if (index >= 0) {
                this.removeSuperIndex(index);
                return index - this.offset;
            }
            return index + this.offset;
        }

        @Override
        public E remove(int index) {
            this.checkSubIndex(index);
            this.checkModification();
            Object previous = SortedArraySet.this.array[index += this.offset];
            this.removeSuperIndex(index);
            return previous;
        }

        @Override
        public void clear() {
            this.checkModification();
            ++this.modCount;
            SortedArraySet.this.removeRange(this.offset, this.offset + this.size);
            this.expectedModCount = SortedArraySet.this.modCount;
            this.size = 0;
        }

        @Override
        public final boolean remove(@NonNull Object o) {
            return this.removeE(o) >= 0;
        }

        @Override
        public E get(int index) {
            this.checkSubIndex(index);
            this.checkModification();
            return SortedArraySet.this.array[this.offset + index];
        }

        @Override
        public @NonNull Object[] toArray() {
            this.checkModification();
            Object[] a = new Object[this.size];
            System.arraycopy(SortedArraySet.this.array, this.offset, a, 0, a.length);
            return a;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkModification();
            int s = this.size;
            if (a.length < s) {
                return Arrays.copyOfRange(SortedArraySet.this.array, this.offset, s - this.offset, a.getClass());
            }
            System.arraycopy(SortedArraySet.this.array, this.offset, a, 0, s - this.offset);
            if (a.length > s) {
                a[s] = null;
            }
            return a;
        }

        @Override
        public SortedListSet<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > this.size || toIndex < 0 || toIndex > this.size) {
                throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
            }
            return new SubList(this.offset + fromIndex, fromIndex - toIndex);
        }
    }
}

