/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.state.resource;

import org.eclipse.linuxtools.lttng.core.model.ILTTngTreeNode;
import org.eclipse.linuxtools.lttng.core.state.resource.ILttngStateContext;

public interface ILTTngStateResource<E extends ILTTngStateResource<E>>
extends ILTTngTreeNode<E> {
    public GlobalStateMode getStateMode();

    public ILttngStateContext getContext();

    public static enum GlobalStateMode {
        LTT_STATEMODE_UNNAMED("unnamed"),
        LTT_STATEMODE_UNKNOWN("unknown"),
        LTT_STATEMODE_IDLE("idle"),
        LTT_STATEMODE_BUSY("busy"),
        LTT_STATEMODE_PENDING("pending"),
        LTT_STATEMODE_READING("reading"),
        LTT_STATEMODE_WRITING("writing"),
        LTT_STATEMODE_IRQ("irq"),
        LTT_STATEMODE_SOFTIRQ("softirq"),
        LTT_STATEMODE_TRAP("trap"),
        LTT_STATEMODE_WAIT_FORK("waitfork"),
        LTT_STATEMODE_WAIT_CPU("waitcpu"),
        LTT_STATEMODE_EXIT("exit"),
        LTT_STATEMODE_ZOMBIE("zombie"),
        LTT_STATEMODE_WAIT_IO("waitio"),
        LTT_STATEMODE_RUN("run"),
        LTT_STATEMODE_DEAD("dead"),
        LTT_STATEMODE_USER_MODE("usermode"),
        LTT_STATEMODE_SYSCALL("syscall");

        String inName;

        private GlobalStateMode(String name) {
            this.inName = name;
        }

        public String getInName() {
            return this.inName;
        }
    }

    public static enum ResourceType {
        LTT_RESOURCE_PROCESS("process"),
        LTT_RESOURCE_CPU("cpu"),
        LTT_RESOURCE_BDEV("bdev"),
        LTT_RESOURCE_IRQ("irq"),
        LTT_RESOURCE_SOFTIRQ("softIrq"),
        LTT_RESOURCE_TRAP("trap"),
        LTT_RESOURCE_RUNNING_PROCESS("running");

        String inName;

        private ResourceType(String name) {
            this.inName = name;
        }

        public String getInName() {
            return this.inName;
        }
    }
}

