/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.util.Random;
import java.util.SplittableRandom;

public class RandomFactory {
    private static Long getSystemSeed() {
        Long seed = null;
        try {
            seed = Long.valueOf(System.getProperty("seed"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return seed;
    }

    private static long getRandomSeed() {
        return new Random().nextLong();
    }

    public static long getSeed() {
        Long seed = RandomFactory.getSystemSeed();
        if (seed == null) {
            seed = RandomFactory.getRandomSeed();
        }
        System.out.println("Seed from RandomFactory = " + seed + "L");
        return seed;
    }

    public static Random getRandom() {
        return new Random(RandomFactory.getSeed());
    }

    public static SplittableRandom getSplittableRandom() {
        return new SplittableRandom(RandomFactory.getSeed());
    }
}

