/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import sun.swing.plaf.synth.DefaultSynthStyle;

class ParsedSynthStyle
extends DefaultSynthStyle {
    private static SynthPainter DELEGATING_PAINTER_INSTANCE = new DelegatingPainter();
    private PainterInfo[] _painters;

    private static PainterInfo[] mergePainterInfo(PainterInfo[] painterInfoArray, PainterInfo[] painterInfoArray2) {
        if (painterInfoArray == null) {
            return painterInfoArray2;
        }
        if (painterInfoArray2 == null) {
            return painterInfoArray;
        }
        int n = painterInfoArray.length;
        int n2 = painterInfoArray2.length;
        int n3 = 0;
        PainterInfo[] painterInfoArray3 = new PainterInfo[n + n2];
        System.arraycopy(painterInfoArray, 0, painterInfoArray3, 0, n);
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            for (int j = 0; j < n - n3; ++j) {
                if (!painterInfoArray2[i].equalsPainter(painterInfoArray[j])) continue;
                painterInfoArray3[j] = painterInfoArray2[i];
                ++n3;
                bl = true;
                break;
            }
            if (bl) continue;
            painterInfoArray3[n + i - n3] = painterInfoArray2[i];
        }
        if (n3 > 0) {
            PainterInfo[] painterInfoArray4 = painterInfoArray3;
            painterInfoArray3 = new PainterInfo[painterInfoArray3.length - n3];
            System.arraycopy(painterInfoArray4, 0, painterInfoArray3, 0, painterInfoArray3.length);
        }
        return painterInfoArray3;
    }

    public ParsedSynthStyle() {
    }

    public ParsedSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof ParsedSynthStyle) {
            ParsedSynthStyle parsedSynthStyle = (ParsedSynthStyle)defaultSynthStyle;
            if (parsedSynthStyle._painters != null) {
                this._painters = parsedSynthStyle._painters;
            }
        }
    }

    @Override
    public SynthPainter getPainter(SynthContext synthContext) {
        return DELEGATING_PAINTER_INSTANCE;
    }

    public void setPainters(PainterInfo[] painterInfoArray) {
        this._painters = painterInfoArray;
    }

    @Override
    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof ParsedSynthStyle)) {
            defaultSynthStyle = new ParsedSynthStyle(defaultSynthStyle);
        }
        ParsedSynthStyle parsedSynthStyle = (ParsedSynthStyle)super.addTo(defaultSynthStyle);
        parsedSynthStyle._painters = ParsedSynthStyle.mergePainterInfo(parsedSynthStyle._painters, this._painters);
        return parsedSynthStyle;
    }

    private SynthPainter getBestPainter(SynthContext synthContext, String string, int n) {
        SynthPainter synthPainter;
        StateInfo stateInfo = (StateInfo)this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null && (synthPainter = this.getBestPainter(stateInfo.getPainters(), string, n)) != null) {
            return synthPainter;
        }
        synthPainter = this.getBestPainter(this._painters, string, n);
        if (synthPainter != null) {
            return synthPainter;
        }
        return SynthPainter.NULL_PAINTER;
    }

    private SynthPainter getBestPainter(PainterInfo[] painterInfoArray, String string, int n) {
        if (painterInfoArray != null) {
            SynthPainter synthPainter = null;
            SynthPainter synthPainter2 = null;
            for (int i = painterInfoArray.length - 1; i >= 0; --i) {
                PainterInfo painterInfo = painterInfoArray[i];
                if (painterInfo.getMethod() == string) {
                    if (painterInfo.getDirection() == n) {
                        return painterInfo.getPainter();
                    }
                    if (synthPainter2 != null || painterInfo.getDirection() != -1) continue;
                    synthPainter2 = painterInfo.getPainter();
                    continue;
                }
                if (synthPainter != null || painterInfo.getMethod() != null) continue;
                synthPainter = painterInfo.getPainter();
            }
            if (synthPainter2 != null) {
                return synthPainter2;
            }
            return synthPainter;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this._painters != null) {
            stringBuffer.append(",painters=[");
            for (int i = 0; i < this._painters.length; ++i) {
                stringBuffer.append(this._painters[i].toString());
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private static class DelegatingPainter
    extends SynthPainter {
        private DelegatingPainter() {
        }

        private static SynthPainter getPainter(SynthContext synthContext, String string, int n) {
            return ((ParsedSynthStyle)synthContext.getStyle()).getBestPainter(synthContext, string, n);
        }

        @Override
        public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "arrowbuttonbackground", -1).paintArrowButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "arrowbuttonborder", -1).paintArrowButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "arrowbuttonforeground", n5).paintArrowButtonForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "buttonbackground", -1).paintButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "buttonborder", -1).paintButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkboxmenuitembackground", -1).paintCheckBoxMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintCheckBoxMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkboxmenuitemborder", -1).paintCheckBoxMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkboxbackground", -1).paintCheckBoxBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintCheckBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkboxborder", -1).paintCheckBoxBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintColorChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "colorchooserbackground", -1).paintColorChooserBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintColorChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "colorchooserborder", -1).paintColorChooserBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "comboboxbackground", -1).paintComboBoxBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintComboBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "comboboxborder", -1).paintComboBoxBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintDesktopIconBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopiconbackground", -1).paintDesktopIconBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopiconborder", -1).paintDesktopIconBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktoppanebackground", -1).paintDesktopPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintDesktopPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktoppaneborder", -1).paintDesktopPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintEditorPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "editorpanebackground", -1).paintEditorPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintEditorPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "editorpaneborder", -1).paintEditorPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintFileChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "filechooserbackground", -1).paintFileChooserBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintFileChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "filechooserborder", -1).paintFileChooserBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "formattedtextfieldbackground", -1).paintFormattedTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintFormattedTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "formattedtextfieldborder", -1).paintFormattedTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalframetitlepanebackground", -1).paintInternalFrameTitlePaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalframetitlepaneborder", -1).paintInternalFrameTitlePaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalframebackground", -1).paintInternalFrameBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalframeborder", -1).paintInternalFrameBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "labelbackground", -1).paintLabelBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintLabelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "labelborder", -1).paintLabelBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintListBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "listbackground", -1).paintListBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintListBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "listborder", -1).paintListBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menubarbackground", -1).paintMenuBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menubarborder", -1).paintMenuBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuitembackground", -1).paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuitemborder", -1).paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menubackground", -1).paintMenuBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuborder", -1).paintMenuBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintOptionPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "optionpanebackground", -1).paintOptionPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintOptionPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "optionpaneborder", -1).paintOptionPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "panelbackground", -1).paintPanelBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "panelborder", -1).paintPanelBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "passwordfieldbackground", -1).paintPasswordFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPasswordFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "passwordfieldborder", -1).paintPasswordFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "popupmenubackground", -1).paintPopupMenuBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "popupmenuborder", -1).paintPopupMenuBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "progressbarbackground", -1).paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "progressbarbackground", n5).paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "progressbarborder", -1).paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "progressbarborder", n5).paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "progressbarforeground", n5).paintProgressBarForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radiobuttonmenuitembackground", -1).paintRadioButtonMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintRadioButtonMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radiobuttonmenuitemborder", -1).paintRadioButtonMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radiobuttonbackground", -1).paintRadioButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintRadioButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radiobuttonborder", -1).paintRadioButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "rootpanebackground", -1).paintRootPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintRootPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "rootpaneborder", -1).paintRootPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollbarbackground", -1).paintScrollBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbarbackground", n5).paintScrollBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollbarborder", -1).paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbarborder", n5).paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbarthumbbackground", n5).paintScrollBarThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollBarThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbarthumbborder", n5).paintScrollBarThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollbartrackbackground", -1).paintScrollBarTrackBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbartrackbackground", n5).paintScrollBarTrackBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollbartrackborder", -1).paintScrollBarTrackBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollbartrackborder", n5).paintScrollBarTrackBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollpanebackground", -1).paintScrollPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollpaneborder", -1).paintScrollPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "separatorbackground", -1).paintSeparatorBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "separatorbackground", n5).paintSeparatorBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "separatorborder", -1).paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "separatorborder", n5).paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "separatorforeground", n5).paintSeparatorForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderbackground", -1).paintSliderBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderbackground", n5).paintSliderBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderborder", -1).paintSliderBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderborder", n5).paintSliderBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderthumbbackground", n5).paintSliderThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderthumbborder", n5).paintSliderThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "slidertrackbackground", -1).paintSliderTrackBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "slidertrackbackground", n5).paintSliderTrackBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "slidertrackborder", -1).paintSliderTrackBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "slidertrackborder", n5).paintSliderTrackBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "spinnerbackground", -1).paintSpinnerBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSpinnerBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "spinnerborder", -1).paintSpinnerBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitpanedividerbackground", -1).paintSplitPaneDividerBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "splitpanedividerbackground", n5).paintSplitPaneDividerBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "splitpanedividerforeground", n5).paintSplitPaneDividerForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "splitpanedragdivider", n5).paintSplitPaneDragDivider(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintSplitPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitpanebackground", -1).paintSplitPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintSplitPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitpaneborder", -1).paintSplitPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanebackground", -1).paintTabbedPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpaneborder", -1).paintTabbedPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabareabackground", -1).paintTabbedPaneTabAreaBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabareabackground", n5).paintTabbedPaneTabAreaBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabareaborder", -1).paintTabbedPaneTabAreaBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabareaborder", n5).paintTabbedPaneTabAreaBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabbackground", -1).paintTabbedPaneTabBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabbackground", n6).paintTabbedPaneTabBackground(synthContext, graphics, n, n2, n3, n4, n5, n6);
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabborder", -1).paintTabbedPaneTabBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanetabborder", n6).paintTabbedPaneTabBorder(synthContext, graphics, n, n2, n3, n4, n5, n6);
        }

        @Override
        public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanecontentbackground", -1).paintTabbedPaneContentBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedpanecontentborder", -1).paintTabbedPaneContentBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTableHeaderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableheaderbackground", -1).paintTableHeaderBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTableHeaderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableheaderborder", -1).paintTableHeaderBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTableBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tablebackground", -1).paintTableBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTableBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableborder", -1).paintTableBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textareabackground", -1).paintTextAreaBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textareaborder", -1).paintTextAreaBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textpanebackground", -1).paintTextPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textpaneborder", -1).paintTextPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textfieldbackground", -1).paintTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textfieldborder", -1).paintTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "togglebuttonbackground", -1).paintToggleButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToggleButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "togglebuttonborder", -1).paintToggleButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbarbackground", -1).paintToolBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbarbackground", n5).paintToolBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbarborder", -1).paintToolBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbarborder", n5).paintToolBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbarcontentbackground", -1).paintToolBarContentBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbarcontentbackground", n5).paintToolBarContentBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbarcontentborder", -1).paintToolBarContentBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbarcontentborder", n5).paintToolBarContentBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbardragwindowbackground", -1).paintToolBarDragWindowBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbardragwindowbackground", n5).paintToolBarDragWindowBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolbardragwindowborder", -1).paintToolBarDragWindowBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "toolbardragwindowborder", n5).paintToolBarDragWindowBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        @Override
        public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tooltipbackground", -1).paintToolTipBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintToolTipBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tooltipborder", -1).paintToolTipBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treebackground", -1).paintTreeBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTreeBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeborder", -1).paintTreeBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treecellbackground", -1).paintTreeCellBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTreeCellBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treecellborder", -1).paintTreeCellBorder(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treecellfocus", -1).paintTreeCellFocus(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "viewportbackground", -1).paintViewportBackground(synthContext, graphics, n, n2, n3, n4);
        }

        @Override
        public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "viewportborder", -1).paintViewportBorder(synthContext, graphics, n, n2, n3, n4);
        }
    }

    private static class AggregatePainter
    extends SynthPainter {
        private List<SynthPainter> painters = new LinkedList<SynthPainter>();

        AggregatePainter(SynthPainter synthPainter) {
            this.painters.add(synthPainter);
        }

        void addPainter(SynthPainter synthPainter) {
            if (synthPainter != null) {
                this.painters.add(synthPainter);
            }
        }

        @Override
        public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintArrowButtonBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintArrowButtonBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintArrowButtonForeground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintButtonBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintButtonBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintCheckBoxMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintCheckBoxMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintCheckBoxMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintCheckBoxBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintCheckBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintCheckBoxBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintColorChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintColorChooserBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintColorChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintColorChooserBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintComboBoxBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintComboBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintComboBoxBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintDesktopIconBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintDesktopIconBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintDesktopIconBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintDesktopPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintDesktopPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintDesktopPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintEditorPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintEditorPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintEditorPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintEditorPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintFileChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintFileChooserBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintFileChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintFileChooserBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintFormattedTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintFormattedTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintFormattedTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintInternalFrameTitlePaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintInternalFrameTitlePaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintInternalFrameBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintInternalFrameBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintLabelBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintLabelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintLabelBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintListBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintListBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintListBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintListBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuBarBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuBarBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintMenuBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintOptionPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintOptionPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintOptionPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintOptionPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPanelBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPanelBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPasswordFieldBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPasswordFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPasswordFieldBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPopupMenuBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintPopupMenuBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintProgressBarForeground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRadioButtonMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintRadioButtonMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRadioButtonMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRadioButtonBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintRadioButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRadioButtonBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRootPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintRootPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintRootPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollBarThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarTrackBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarTrackBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarTrackBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollBarTrackBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintScrollPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSeparatorBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSeparatorBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSeparatorForeground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderTrackBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderTrackBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderTrackBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSliderTrackBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSpinnerBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSpinnerBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSpinnerBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneDividerBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneDividerBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneDividerForeground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneDragDivider(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintSplitPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintSplitPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintSplitPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabAreaBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabAreaBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabAreaBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabAreaBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabBackground(synthContext, graphics, n, n2, n3, n4, n5, n6);
            }
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneTabBorder(synthContext, graphics, n, n2, n3, n4, n5, n6);
            }
        }

        @Override
        public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneContentBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTabbedPaneContentBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTableHeaderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTableHeaderBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTableHeaderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTableHeaderBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTableBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTableBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTableBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTableBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextAreaBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextAreaBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextPaneBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextPaneBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToggleButtonBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToggleButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToggleButtonBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarContentBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarContentBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarContentBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarContentBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarDragWindowBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarDragWindowBackground(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarDragWindowBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolBarDragWindowBorder(synthContext, graphics, n, n2, n3, n4, n5);
            }
        }

        @Override
        public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolTipBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintToolTipBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintToolTipBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTreeBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTreeBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTreeBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTreeCellBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTreeCellBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTreeCellBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintTreeCellFocus(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintViewportBackground(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            for (SynthPainter synthPainter : this.painters) {
                synthPainter.paintViewportBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }
    }

    static class PainterInfo {
        private String _method;
        private SynthPainter _painter;
        private int _direction;

        PainterInfo(String string, SynthPainter synthPainter, int n) {
            if (string != null) {
                this._method = string.intern();
            }
            this._painter = synthPainter;
            this._direction = n;
        }

        void addPainter(SynthPainter synthPainter) {
            if (!(this._painter instanceof AggregatePainter)) {
                this._painter = new AggregatePainter(this._painter);
            }
            ((AggregatePainter)this._painter).addPainter(synthPainter);
        }

        String getMethod() {
            return this._method;
        }

        SynthPainter getPainter() {
            return this._painter;
        }

        int getDirection() {
            return this._direction;
        }

        boolean equalsPainter(PainterInfo painterInfo) {
            return this._method == painterInfo._method && this._direction == painterInfo._direction;
        }

        public String toString() {
            return "PainterInfo {method=" + this._method + ",direction=" + this._direction + ",painter=" + this._painter + "}";
        }
    }

    static class StateInfo
    extends DefaultSynthStyle.StateInfo {
        private PainterInfo[] _painterInfo;

        public StateInfo() {
        }

        public StateInfo(DefaultSynthStyle.StateInfo stateInfo) {
            super(stateInfo);
            if (stateInfo instanceof StateInfo) {
                this._painterInfo = ((StateInfo)stateInfo)._painterInfo;
            }
        }

        public void setPainters(PainterInfo[] painterInfoArray) {
            this._painterInfo = painterInfoArray;
        }

        public PainterInfo[] getPainters() {
            return this._painterInfo;
        }

        @Override
        public Object clone() {
            return new StateInfo(this);
        }

        @Override
        public DefaultSynthStyle.StateInfo addTo(DefaultSynthStyle.StateInfo stateInfo) {
            if (!(stateInfo instanceof StateInfo)) {
                stateInfo = new StateInfo(stateInfo);
            } else {
                stateInfo = super.addTo(stateInfo);
                StateInfo stateInfo2 = (StateInfo)stateInfo;
                stateInfo2._painterInfo = ParsedSynthStyle.mergePainterInfo(stateInfo2._painterInfo, this._painterInfo);
            }
            return stateInfo;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(",painters=[");
            if (this._painterInfo != null) {
                for (int i = 0; i < this._painterInfo.length; ++i) {
                    stringBuffer.append("    ").append(this._painterInfo[i].toString());
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

