/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.ui.actions.QuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public abstract class JDTQuickMenuAction
extends QuickMenuAction {
    private JavaEditor fEditor;

    public JDTQuickMenuAction(String commandId) {
        super(commandId);
    }

    public JDTQuickMenuAction(JavaEditor editor, String commandId) {
        super(commandId);
        this.fEditor = editor;
    }

    @Override
    protected Point computeMenuLocation(StyledText text) {
        if (this.fEditor == null || text != this.fEditor.getViewer().getTextWidget()) {
            return null;
        }
        return this.computeWordStart();
    }

    private Point computeWordStart() {
        ITextSelection selection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        IRegion textRegion = JavaWordFinder.findWord(this.fEditor.getViewer().getDocument(), selection.getOffset());
        if (textRegion == null) {
            return null;
        }
        IRegion widgetRegion = this.modelRange2WidgetRange(textRegion);
        if (widgetRegion == null) {
            return null;
        }
        int start = widgetRegion.getOffset();
        StyledText styledText = this.fEditor.getViewer().getTextWidget();
        Point result = styledText.getLocationAtOffset(start);
        result.y += styledText.getLineHeight(start);
        if (!styledText.getClientArea().contains(result)) {
            return null;
        }
        return result;
    }

    private IRegion modelRange2WidgetRange(IRegion region) {
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = viewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }
}

