/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.stubs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartDurationDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartTimestampDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractLongResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;

@NonNullByDefault
public class StubChartProviderFull
extends StubChartProvider {
    public static final String SECOND_STRING_DESCRIPTOR = "String2";
    public static final String DURATION_DESCRIPTOR = "Duration";
    public static final String SECOND_DURATION_DESCRIPTOR = "Duration2";
    public static final String TIMESTAMP_DESCRIPTOR = "Timestamp";
    public static final String SECOND_TIMESTAMP_DESCRIPTOR = "Timestamp2";
    private @Nullable List<IDataChartDescriptor<StubObject, ?>> fDescriptors = null;

    @Override
    public Collection<IDataChartDescriptor<StubObject, ?>> getDataDescriptors() {
        List<IDataChartDescriptor<StubObject, ?>> descriptors = this.fDescriptors;
        if (descriptors == null) {
            descriptors = new ArrayList(super.getDataDescriptors());
            descriptors.add((IDataChartDescriptor<StubObject, ?>)new DataChartStringDescriptor(SECOND_STRING_DESCRIPTOR, (IStringResolver)new IStringResolver<StubObject>(){

                public @NonNull Function<StubObject, @Nullable String> getMapper() {
                    return o -> "alt_" + o.getString();
                }
            }));
            descriptors.add((IDataChartDescriptor<StubObject, ?>)new DataChartDurationDescriptor(DURATION_DESCRIPTOR, (INumericalResolver)new INumericalResolver<StubObject, Integer>(){

                public @NonNull Function<StubObject, @Nullable Integer> getMapper() {
                    return o -> o.getInt();
                }

                public @NonNull Comparator<@NonNull Integer> getComparator() {
                    return (Comparator)NonNullUtils.checkNotNull(Comparator.naturalOrder());
                }

                public Integer getMinValue() {
                    return Integer.MIN_VALUE;
                }

                public Integer getMaxValue() {
                    return Integer.MAX_VALUE;
                }

                public Integer getZeroValue() {
                    return 0;
                }
            }));
            descriptors.add((IDataChartDescriptor<StubObject, ?>)new DataChartDurationDescriptor(SECOND_DURATION_DESCRIPTOR, (INumericalResolver)new INumericalResolver<StubObject, Integer>(){

                public @NonNull Function<StubObject, @Nullable Integer> getMapper() {
                    return o -> o.getInt() + 10;
                }

                public @NonNull Comparator<@NonNull Integer> getComparator() {
                    return (Comparator)NonNullUtils.checkNotNull(Comparator.naturalOrder());
                }

                public Integer getMinValue() {
                    return Integer.MIN_VALUE;
                }

                public Integer getMaxValue() {
                    return Integer.MAX_VALUE;
                }

                public Integer getZeroValue() {
                    return 0;
                }
            }));
            descriptors.add((IDataChartDescriptor<StubObject, ?>)new DataChartTimestampDescriptor(TIMESTAMP_DESCRIPTOR, (INumericalResolver)new AbstractLongResolver<StubObject>(){

                public @NonNull Function<StubObject, @Nullable Long> getMapper() {
                    return o -> o.getLong();
                }
            }));
            descriptors.add((IDataChartDescriptor<StubObject, ?>)new DataChartTimestampDescriptor(SECOND_TIMESTAMP_DESCRIPTOR, (INumericalResolver)new AbstractLongResolver<StubObject>(){

                public @NonNull Function<StubObject, @Nullable Long> getMapper() {
                    return o -> o.getLong() + 1000L;
                }
            }));
            this.fDescriptors = descriptors;
        }
        return descriptors;
    }
}

