/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFTraceGrowingStreamTest {
    private Path fCtfDirectory;
    private File fGrowingStream;
    private byte[][] fPackets;
    private CTFTrace fFixture;
    private UUID fUUID;

    @Before
    public void init() throws IOException, CTFException {
        this.fCtfDirectory = Files.createTempDirectory("temptrace", new FileAttribute[0]);
        File metadata = new File(this.fCtfDirectory.toString() + "/metadata");
        this.fGrowingStream = new File(this.fCtfDirectory.toString() + "/stream");
        this.fUUID = UUID.randomUUID();
        this.fPackets = new byte[2][];
        this.fPackets[0] = new byte[32];
        this.fPackets[1] = new byte[32];
        Throwable throwable = null;
        Object var3_5 = null;
        try (PrintWriter pw = new PrintWriter(metadata);){
            pw.println("/*CTF 1.8*/");
            pw.println("typealias integer { size = 8; align = 8; signed = false; base = 10; } := uint8_t;");
            pw.println("typealias integer { size = 32; align = 32; signed = false; base = hex; } := uint32_t;");
            pw.println("trace {");
            pw.println(" major = 0;");
            pw.println(" minor = 1;");
            pw.println(" uuid = \"" + this.fUUID.toString() + "\";");
            pw.println(" byte_order = le;");
            pw.println(" packet.header := struct {");
            pw.println("  uint32_t magic;");
            pw.println("  uint8_t uuid[16];");
            pw.println(" };");
            pw.println("};");
            pw.println("");
            pw.println("stream {");
            pw.println(" packet.context := struct {");
            pw.println("  uint32_t packet_size;");
            pw.println("  uint32_t content_size;");
            pw.println(" };");
            pw.println("};");
            pw.println("");
            pw.println("event {");
            pw.println(" name = thing;");
            pw.println(" fields := struct { uint32_t f; };");
            pw.println("};");
            pw.println("");
            pw.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.setupPacket(this.fPackets[0], 41);
        this.setupPacket(this.fPackets[1], -1162544434);
        throwable = null;
        var3_5 = null;
        try (FileOutputStream fos = new FileOutputStream(this.fGrowingStream);){
            fos.write(this.fPackets[0]);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.fFixture = new CTFTrace(this.fCtfDirectory.toString());
    }

    private void setupPacket(byte[] data, int value) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.clear();
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(-1040441407);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putLong(this.fUUID.getMostSignificantBits());
        bb.putLong(this.fUUID.getLeastSignificantBits());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(256);
        bb.putInt(256);
        bb.putInt(value);
    }

    @Test
    public void testGrowingLive() throws CTFException, FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fFixture);){
            reader.setLive(true);
            Assert.assertEquals((Object)"0x29", (Object)reader.getCurrentEventDef().getFields().getDefinition("f").toString());
            reader.advance();
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (FileOutputStream fos = new FileOutputStream(this.fGrowingStream, true);){
                fos.write(this.fPackets[1]);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            reader.advance();
            Assert.assertNotNull((Object)reader.getCurrentEventDef());
            Assert.assertEquals((Object)"0xbab4face", (Object)reader.getCurrentEventDef().getFields().getDefinition("f").toString());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testGrowingNotLive() throws CTFException, FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CTFTraceReader reader = new CTFTraceReader(this.fFixture);){
            reader.setLive(false);
            Assert.assertEquals((Object)"0x29", (Object)reader.getCurrentEventDef().getFields().getDefinition("f").toString());
            reader.advance();
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (FileOutputStream fos = new FileOutputStream(this.fGrowingStream, true);){
                fos.write(this.fPackets[1]);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            reader.advance();
            Assert.assertNull((Object)reader.getCurrentEventDef());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

