/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlOutputEntryCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlXYViewCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYProviderFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlXyDataProviderTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String ANALYSIS_ID = "xml.core.tests.simple.pattern";
    private static final @NonNull String XY_VIEW_ID = "xml.core.tests.simple.pattern.xy";
    private static final @NonNull String XY_VIEW_ID_DELTA = "xml.core.tests.simple.pattern.xy.delta";
    private static final @NonNull IProgressMonitor MONITOR = new NullProgressMonitor();

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    public void cleanUp() {
        XmlUtils.deleteFiles((Collection)ImmutableList.of((Object)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), (Object)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile().getName()));
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private ITmfTrace getTrace() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
        ((TmfTrace)trace).traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
        return trace;
    }

    private static void runModule(ITmfTrace trace) {
        IAnalysisModule module = trace.getAnalysisModule(ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testXYDataProvider() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlXyDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"xyView", (String)XY_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITmfTreeXYDataProvider xyProvider = XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
            Assert.assertNotNull((Object)xyProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYTree", new String[0]));
            Map<Long, String> tree = XmlXyDataProviderTest.assertAndGetTree((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYData", new String[0]));
            XmlXyDataProviderTest.assertRows((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testXYDataProviderDelta() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlXyDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"xyView", (String)XY_VIEW_ID_DELTA);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITmfTreeXYDataProvider xyProvider = XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
            Assert.assertNotNull((Object)xyProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYTree", new String[0]));
            Map<Long, String> tree = XmlXyDataProviderTest.assertAndGetTree((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYDataDelta", new String[0]));
            XmlXyDataProviderTest.assertRows((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testXYFactory() {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlXyDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"xyView", (String)XY_VIEW_ID_DELTA);
            Assert.assertNotNull((Object)viewElement);
            TmfXmlXYViewCu tgViewCu = TmfXmlXYViewCu.compile((AnalysisCompilationData)new AnalysisCompilationData(), (Element)viewElement);
            Assert.assertNotNull((Object)tgViewCu);
            DataDrivenXYProviderFactory XYFactory = tgViewCu.generate();
            @NonNull ITmfTreeXYDataProvider provider = XYFactory.create(trace);
            Assert.assertNotNull((Object)provider);
            Assert.assertEquals((Object)"org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider", (Object)provider.getId());
            ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)ANALYSIS_ID);
            Assert.assertNotNull((Object)module);
            @NonNull Iterable stateSystems = module.getStateSystems();
            Assert.assertNotNull((Object)stateSystems);
            provider = DataDrivenXYProviderFactory.create((ITmfTrace)trace, (List)Objects.requireNonNull(Lists.newArrayList((Iterable)stateSystems)), XmlXyDataProviderTest.getEntries(new AnalysisCompilationData(), viewElement), (String)ANALYSIS_ID);
            Assert.assertNotNull((Object)provider);
            Assert.assertEquals((Object)ANALYSIS_ID, (Object)provider.getId());
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    private static List<DataDrivenOutputEntry> getEntries(AnalysisCompilationData compilationData, Element viewElement) {
        List entries = TmfXmlUtils.getChildElements((Element)viewElement, (String)"entry");
        ArrayList<TmfXmlOutputEntryCu> entriesCu = new ArrayList<TmfXmlOutputEntryCu>();
        for (Element entry : entries) {
            TmfXmlOutputEntryCu entryCu = TmfXmlOutputEntryCu.compile((AnalysisCompilationData)compilationData, (Element)entry);
            if (entryCu == null) continue;
            entriesCu.add(entryCu);
        }
        return entriesCu.stream().map(TmfXmlOutputEntryCu::generate).collect(Collectors.toList());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertRows(ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> xyProvider, Map<Long, String> tree, List<String> expectedStrings) {
        @NonNull TmfModelResponse rowResponse = xyProvider.fetchXY(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(1L, 20L, 20, tree.keySet())), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        ITmfXyModel rowModel = (ITmfXyModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        @NonNull Collection series = rowModel.getSeriesData();
        @NonNull ImmutableMap data = Maps.uniqueIndex((Iterable)series, ISeriesModel::getId);
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            String rowName = split[0];
            Long rowId = null;
            for (Map.Entry<Long, String> entry : tree.entrySet()) {
                if (!entry.getValue().equals(rowName)) continue;
                rowId = entry.getKey();
                break;
            }
            Assert.assertNotNull(rowId);
            ISeriesModel row = (ISeriesModel)data.get(rowId);
            Assert.assertNotNull((Object)row);
            String[] expectedData = split[1].split(",");
            double[] actualData = row.getData();
            int j = 0;
            while (j < expectedData.length) {
                Assert.assertTrue((String)("Presence of data at position " + j + " for row " + rowName), (actualData.length > j ? 1 : 0) != 0);
                double expectedValue = Double.parseDouble(expectedData[j]);
                Assert.assertEquals((String)("Data at position " + j + " for row " + rowName), (double)expectedValue, (double)actualData[j], (double)0.001);
                ++j;
            }
            ++i;
        }
        Assert.assertEquals((String)"Same number of data", (long)expectedStrings.size(), (long)data.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<Long, String> assertAndGetTree(ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> xyProvider, ITmfTrace trace, List<String> expectedStrings) {
        @NonNull @NonNull TmfModelResponse treeResponse = xyProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), MONITOR);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        @NonNull List treeEntries = treeModel.getEntries();
        HashMap<Long, String> map = new HashMap<Long, String>();
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            Assert.assertTrue((String)("actual entry absent at " + i + ": " + expectedString), (treeEntries.size() > i ? 1 : 0) != 0);
            String[] split = expectedString.split(",");
            ITmfTreeDataModel xmlXyEntry = (ITmfTreeDataModel)treeEntries.get(i);
            Assert.assertEquals((String)("Checking entry name at " + i), (Object)split[0], (Object)xmlXyEntry.getName());
            long parentId = xmlXyEntry.getParentId();
            if (parentId < 0L) {
                Assert.assertEquals((String)("Checking empty parent at " + i), (Object)split[1], (Object)"null");
            } else {
                String parentName = (String)map.get(parentId);
                Assert.assertEquals((String)("Checking parent at " + i), (Object)split[1], (Object)parentName);
            }
            map.put(xmlXyEntry.getId(), xmlXyEntry.getName());
            ++i;
        }
        Assert.assertEquals((String)"Extra actual entries", (long)expectedStrings.size(), (long)treeEntries.size());
        return map;
    }
}

