/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.descriptor;

import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractLongResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.junit.Assert;
import org.junit.Test;

public class NumericalDescriptorTest {
    private static final @NonNull String DESC_NAME = "test";
    private final @NonNull INumericalResolver<StubObject, @NonNull Long> fResolver = new AbstractLongResolver<StubObject>(){

        public @NonNull Function<StubObject, @Nullable Long> getMapper() {
            return o -> o.getLong();
        }
    };

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConstructor() {
        @NonNull DataChartNumericalDescriptor desc = new DataChartNumericalDescriptor(DESC_NAME, this.fResolver);
        Assert.assertEquals((Object)DESC_NAME, (Object)desc.getName());
        Assert.assertNull((Object)desc.getUnit());
        Assert.assertEquals((Object)DESC_NAME, (Object)desc.getLabel());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConstructorWithUnit() {
        String unit = "bla";
        @NonNull DataChartNumericalDescriptor desc = new DataChartNumericalDescriptor(DESC_NAME, this.fResolver, unit);
        Assert.assertEquals((Object)DESC_NAME, (Object)desc.getName());
        Assert.assertEquals((Object)unit, (Object)desc.getUnit());
        Assert.assertEquals((Object)("test (" + unit + ')'), (Object)desc.getLabel());
    }
}

