/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.file.impl.PathResolver;

public class ClasspathPathResolver
implements PathResolver {
    private static final char FILE_SEP = System.getProperty("file.separator").charAt(0);

    public static Path resolvePath(Path path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            Path thePath;
            String spath = path.toString();
            String substituted = FILE_SEP == '/' ? spath : spath.replace(FILE_SEP, '/');
            URL url = cl.getResource(substituted);
            if (url != null && (thePath = ClasspathPathResolver.urlToPath(url)) != null) {
                return thePath;
            }
        }
        return path;
    }

    public static Path urlToPath(URL url) {
        if (FILE_SEP == '/') {
            String sfile = url.getFile();
            if (sfile != null) {
                return Paths.get(url.getFile(), new String[0]);
            }
            return null;
        }
        try {
            URI uri = url.toURI();
            if (uri.isOpaque()) {
                return Paths.get(url.getPath(), new String[0]);
            }
            return Paths.get(uri);
        }
        catch (Exception exc) {
            throw new VertxException(exc);
        }
    }

    @Override
    public Path resolve(Path path) {
        return ClasspathPathResolver.resolvePath(path);
    }
}

