/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import org.vertx.java.core.http.impl.AssembledHttpResponse;
import org.vertx.java.core.http.impl.AssembledLastHttpContent;

class AssembledFullHttpResponse
extends AssembledHttpResponse
implements FullHttpResponse {
    public AssembledFullHttpResponse(HttpResponse response, LastHttpContent content) {
        this(response, content.content(), content.trailingHeaders());
    }

    public AssembledFullHttpResponse(HttpResponse response) {
        this(response, Unpooled.EMPTY_BUFFER);
    }

    public AssembledFullHttpResponse(HttpResponse response, ByteBuf buf) {
        super(response, (HttpContent)AssembledFullHttpResponse.toLastContent(buf, null));
    }

    public AssembledFullHttpResponse(HttpResponse response, ByteBuf buf, HttpHeaders trailingHeaders) {
        super(response, (HttpContent)AssembledFullHttpResponse.toLastContent(buf, trailingHeaders));
    }

    private static LastHttpContent toLastContent(ByteBuf buf, HttpHeaders trailingHeaders) {
        if (buf.isReadable()) {
            if (trailingHeaders == null) {
                return new DefaultLastHttpContent(buf);
            }
            return new AssembledLastHttpContent(buf, trailingHeaders);
        }
        if (trailingHeaders == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        return new AssembledLastHttpContent(Unpooled.EMPTY_BUFFER, trailingHeaders);
    }

    @Override
    public AssembledFullHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public AssembledFullHttpResponse retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public AssembledFullHttpResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public AssembledFullHttpResponse duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssembledFullHttpResponse copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssembledFullHttpResponse setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    public HttpHeaders trailingHeaders() {
        return ((LastHttpContent)this.content).trailingHeaders();
    }
}

