/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ActionPairMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.AppInstanceWithStateMachineMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ApplicationInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.HostInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.StateMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.TransitionMatcher;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RuleProvider {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    @Extension
    private BatchTransformationRuleFactory _batchTransformationRuleFactory = new BatchTransformationRuleFactory();
    @Extension
    private IModelManipulations manipulation;
    @Extension
    protected DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    @Extension
    protected TraceabilityFactory traceFactory = TraceabilityFactory.eINSTANCE;
    private CPSToDeployment mapping;
    private ViatraQueryEngine engine;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> hostRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> applicationRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateMachineRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> transitionRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> actionRule;

    public RuleProvider(ViatraQueryEngine engine, CPSToDeployment deployment) {
        this.mapping = deployment;
        this.engine = engine;
        SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(engine);
        this.manipulation = _simpleModelManipulations;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getHostRule() {
        if (this.hostRule == null) {
            IMatchProcessor _function = it -> {
                HostInstance cpsHostInstance = it.getHostInstance();
                String nodeIp = it.getHostInstance().getNodeIp();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping host with IP: ");
                _builder.append(nodeIp);
                this.logger.debug((Object)_builder);
                DeploymentHost _createDeploymentHost = this.depFactory.createDeploymentHost();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setIp(nodeIp);
                DeploymentHost deploymentHost = (DeploymentHost)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentHost, (Procedures.Procedure1)_function_1);
                EList _hosts = this.mapping.getDeployment().getHosts();
                _hosts.add((Object)deploymentHost);
                EList _traces = this.mapping.getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    EList _cpsElements = it_1.getCpsElements();
                    _cpsElements.add((Object)cpsHostInstance);
                    EList _deploymentElements = it_1.getDeploymentElements();
                    _deploymentElements.add((Object)deploymentHost);
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                _traces.add((Object)_doubleArrow);
            };
            this.hostRule = this._batchTransformationRuleFactory.createRule().name("HostRule").precondition(HostInstanceMatcher.querySpecification()).action(_function).build();
        }
        return this.hostRule;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getApplicationRule() {
        if (this.applicationRule == null) {
            IMatchProcessor _function = it -> {
                ApplicationInstance cpsApplicationInstance = it.getAppInstance();
                String appId = it.getAppInstance().getIdentifier();
                HostInstance cpsHostInstance = cpsApplicationInstance.getAllocatedTo();
                DeploymentHost depHost = (DeploymentHost)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)cpsHostInstance), DeploymentHost.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping application with ID: ");
                _builder.append(appId);
                this.logger.debug((Object)_builder);
                DeploymentApplication _createDeploymentApplication = this.depFactory.createDeploymentApplication();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setId(appId);
                DeploymentApplication deploymentApplication = (DeploymentApplication)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentApplication, (Procedures.Procedure1)_function_1);
                EList _traces = this.mapping.getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    EList _cpsElements = it_1.getCpsElements();
                    _cpsElements.add((Object)cpsApplicationInstance);
                    EList _deploymentElements = it_1.getDeploymentElements();
                    _deploymentElements.add((Object)deploymentApplication);
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                _traces.add((Object)_doubleArrow);
                EList _applications = depHost.getApplications();
                _applications.add((Object)deploymentApplication);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Mapped application with ID: ");
                _builder_1.append(appId);
                this.logger.debug((Object)_builder_1);
            };
            this.applicationRule = this._batchTransformationRuleFactory.createRule().name("ApplicationRule").precondition(ApplicationInstanceMatcher.querySpecification()).action(_function).build();
        }
        return this.applicationRule;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateMachineRule() {
        if (this.stateMachineRule == null) {
            IMatchProcessor _function = it -> {
                ApplicationInstance cpsApplicationInstance = it.getAppInstance();
                StateMachine cpsStateMachine = it.getStateMachine();
                DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)cpsApplicationInstance), DeploymentApplication.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping state machine with ID: ");
                String _identifier = cpsStateMachine.getIdentifier();
                _builder.append(_identifier);
                this.logger.debug((Object)_builder);
                DeploymentBehavior _createDeploymentBehavior = this.depFactory.createDeploymentBehavior();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setDescription(cpsStateMachine.getIdentifier());
                DeploymentBehavior depBehavior = (DeploymentBehavior)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentBehavior, (Procedures.Procedure1)_function_1);
                depApplication.setBehavior(depBehavior);
                CPS2DeploymentTrace trace = this.getTraceForCPSElement((Identifiable)cpsStateMachine);
                if (trace == null) {
                    EList _traces = this.mapping.getTraces();
                    CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                    Procedures.Procedure1 _function_2 = it_1 -> {
                        EList _cpsElements = it_1.getCpsElements();
                        _cpsElements.add((Object)cpsStateMachine);
                        EList _deploymentElements = it_1.getDeploymentElements();
                        _deploymentElements.add((Object)depBehavior);
                    };
                    CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                    _traces.add((Object)_doubleArrow);
                } else {
                    EList _deploymentElements = trace.getDeploymentElements();
                    _deploymentElements.add((Object)depBehavior);
                }
            };
            this.stateMachineRule = this._batchTransformationRuleFactory.createRule().name("StateMachineRule").precondition(AppInstanceWithStateMachineMatcher.querySpecification()).action(_function).build();
        }
        return this.stateMachineRule;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateRule() {
        if (this.stateRule == null) {
            IMatchProcessor _function = it -> {
                StateMachine cpsStateMachine = it.getStateMachine();
                ApplicationInstance cpsAppInstance = it.getAppInstance();
                State cpsState = it.getState();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping state with ID: ");
                String _identifier = cpsState.getIdentifier();
                _builder.append(_identifier);
                this.logger.debug((Object)_builder);
                BehaviorState _createBehaviorState = this.depFactory.createBehaviorState();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setDescription(cpsState.getIdentifier());
                BehaviorState behaviorState = (BehaviorState)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorState, (Procedures.Procedure1)_function_1);
                CPS2DeploymentTrace appInstanceTrace = this.getTraceForCPSElement((Identifiable)cpsAppInstance);
                DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)appInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                DeploymentBehavior depBehavior = depApplication.getBehavior();
                EList _states = depBehavior.getStates();
                _states.add((Object)behaviorState);
                CPS2DeploymentTrace trace = this.getTraceForCPSElement((Identifiable)cpsState);
                if (trace == null) {
                    EList _traces = this.mapping.getTraces();
                    CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                    Procedures.Procedure1 _function_2 = it_1 -> {
                        EList _cpsElements = it_1.getCpsElements();
                        _cpsElements.add((Object)cpsState);
                        EList _deploymentElements = it_1.getDeploymentElements();
                        _deploymentElements.add((Object)behaviorState);
                    };
                    CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                    _traces.add((Object)_doubleArrow);
                } else {
                    EList _deploymentElements = trace.getDeploymentElements();
                    _deploymentElements.add((Object)behaviorState);
                }
                State _initial = cpsStateMachine.getInitial();
                boolean _equals = Objects.equal((Object)_initial, (Object)cpsState);
                if (_equals) {
                    depBehavior.setCurrent(behaviorState);
                }
            };
            this.stateRule = this._batchTransformationRuleFactory.createRule().name("StateRule").precondition(StateMatcher.querySpecification()).action(_function).build();
        }
        return this.stateRule;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTransitionRule() {
        if (this.transitionRule == null) {
            IMatchProcessor _function = it -> {
                ApplicationInstance cpsAppInstance = it.getAppInstance();
                State cpsState = it.getSourceState();
                State cpsTargetState = it.getTargetState();
                Transition cpsTransition = it.getTransition();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping transition with ID: ");
                String _identifier = cpsTransition.getIdentifier();
                _builder.append(_identifier);
                this.logger.debug((Object)_builder);
                BehaviorTransition _createBehaviorTransition = this.depFactory.createBehaviorTransition();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setDescription(cpsTransition.getIdentifier());
                BehaviorTransition behaviorTransition = (BehaviorTransition)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorTransition, (Procedures.Procedure1)_function_1);
                CPS2DeploymentTrace appInstanceTrace = this.getTraceForCPSElement((Identifiable)cpsAppInstance);
                DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)appInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                DeploymentBehavior depBehavior = depApplication.getBehavior();
                EList _transitions = depBehavior.getTransitions();
                _transitions.add((Object)behaviorTransition);
                CPS2DeploymentTrace trace = this.getTraceForCPSElement((Identifiable)cpsTransition);
                if (trace == null) {
                    EList _traces = this.mapping.getTraces();
                    CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                    Procedures.Procedure1 _function_2 = it_1 -> {
                        EList _cpsElements = it_1.getCpsElements();
                        _cpsElements.add((Object)cpsTransition);
                        EList _deploymentElements = it_1.getDeploymentElements();
                        _deploymentElements.add((Object)behaviorTransition);
                    };
                    CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                    _traces.add((Object)_doubleArrow);
                } else {
                    EList _deploymentElements = trace.getDeploymentElements();
                    _deploymentElements.add((Object)behaviorTransition);
                }
                Functions.Function1 _function_3 = it_1 -> {
                    String _description = it_1.getDescription();
                    String _identifier_1 = cpsTargetState.getIdentifier();
                    return Objects.equal((Object)_description, (Object)_identifier_1);
                };
                BehaviorState depTargetState = (BehaviorState)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)depBehavior.getStates(), (Functions.Function1)_function_3));
                Functions.Function1 _function_4 = it_1 -> {
                    String _description = it_1.getDescription();
                    String _identifier_1 = cpsState.getIdentifier();
                    return Objects.equal((Object)_description, (Object)_identifier_1);
                };
                BehaviorState depSourceState = (BehaviorState)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)depBehavior.getStates(), (Functions.Function1)_function_4));
                EList _outgoing = depSourceState.getOutgoing();
                _outgoing.add((Object)behaviorTransition);
                behaviorTransition.setTo(depTargetState);
            };
            this.transitionRule = this._batchTransformationRuleFactory.createRule().name("TransitionRule").precondition(TransitionMatcher.querySpecification()).action(_function).build();
        }
        return this.transitionRule;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getActionRule() {
        if (this.actionRule == null) {
            IMatchProcessor _function = it -> {
                Transition cpsSendTransition = it.getSendTransition();
                ApplicationInstance cpsSendAppInstance = it.getSendAppInstance();
                Transition cpsWaitTransition = it.getWaitTransition();
                ApplicationInstance cpsWaitAppInstance = it.getWaitAppInstance();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mapping trigger between transitions: ");
                String _identifier = cpsSendTransition.getIdentifier();
                _builder.append(_identifier);
                _builder.append(" and ");
                String _identifier_1 = cpsWaitTransition.getIdentifier();
                _builder.append(_identifier_1);
                this.logger.debug((Object)_builder);
                CPS2DeploymentTrace sendTransitionTrace = this.getTraceForCPSElement((Identifiable)cpsSendTransition);
                CPS2DeploymentTrace sendAppInstanceTrace = this.getTraceForCPSElement((Identifiable)cpsSendAppInstance);
                DeploymentApplication depSendApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)sendAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                Functions.Function1 _function_1 = it_1 -> {
                    EObject _eContainer = it_1.eContainer().eContainer();
                    return Objects.equal((Object)depSendApp, (Object)_eContainer);
                };
                BehaviorTransition depSendTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)sendTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function_1);
                CPS2DeploymentTrace waitTransitionTrace = this.getTraceForCPSElement((Identifiable)cpsWaitTransition);
                CPS2DeploymentTrace waitAppInstanceTrace = this.getTraceForCPSElement((Identifiable)cpsWaitAppInstance);
                DeploymentApplication depWaitApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)waitAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                Functions.Function1 _function_2 = it_1 -> {
                    EObject _eContainer = it_1.eContainer().eContainer();
                    return Objects.equal((Object)depWaitApp, (Object)_eContainer);
                };
                BehaviorTransition depWaitTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)waitTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function_2);
                EList _trigger = depSendTransition.getTrigger();
                _trigger.add((Object)depWaitTransition);
            };
            this.actionRule = this._batchTransformationRuleFactory.createRule().name("ActionRule").precondition(ActionPairMatcher.querySpecification()).action(_function).build();
        }
        return this.actionRule;
    }

    public CPS2DeploymentTrace getTraceForCPSElement(Identifiable cpsElement) {
        return (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, cpsElement, null), CPS2DeploymentTrace.class));
    }
}

