/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class AggregatorCheck
extends CheckOperation
implements IPatternMatcherOperation {
    private final int position;
    private final AggregatorConstraint aggregator;
    private final CallInformation information;
    private final VolatileModifiableMaskedTuple maskedTuple;
    private IQueryResultProvider matcher;

    public AggregatorCheck(CallInformation information, AggregatorConstraint aggregator, int position) {
        this.information = information;
        this.position = position;
        this.aggregator = aggregator;
        this.maskedTuple = new VolatileModifiableMaskedTuple(information.getThinFrameMask());
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        super.onInitialize(frame, context);
        this.maskedTuple.updateTuple((IModifiableTuple)frame);
        this.matcher = context.getMatcher(this.information.getReference());
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        IMultisetAggregationOperator operator = this.aggregator.getAggregator().getOperator();
        Object result = this.aggregate(operator, this.aggregator.getAggregatedColumn(), frame);
        return result == null ? false : Objects.equals(frame.getValue(this.position), result);
    }

    private <Domain, Accumulator, AggregateResult> AggregateResult aggregate(IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, int aggregatedColumn, MatchingFrame initialFrame) {
        this.maskedTuple.updateTuple((IModifiableTuple)initialFrame);
        Object accumulator = operator.createNeutral();
        for (Tuple match : this.matcher.getAllMatches(this.information.getParameterMask(), (ITuple)this.maskedTuple)) {
            Object column = match.get(aggregatedColumn);
            accumulator = operator.update(accumulator, column, true);
        }
        return (AggregateResult)operator.getAggregate(accumulator);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    public String toString() {
        return "check     " + this.position + " = " + this.aggregator.getAggregator().getOperator().getName() + " find " + this.information.toString();
    }
}

