/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.tuple;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.Node;

public class MaskedTupleMemory
implements Clearable,
Iterable<Tuple> {
    protected Map<Tuple, Object> matchings;
    protected TupleMask mask;
    protected Node owner;
    private static final Iterator<Tuple> EMPTY_ITERATOR = Collections.emptySet().iterator();

    public MaskedTupleMemory(TupleMask mask, Node owner) {
        this.mask = mask;
        this.owner = owner;
        this.matchings = CollectionsFactory.createMap();
    }

    public boolean add(Tuple ps) {
        Tuple signature = this.mask.transform((ITuple)ps);
        return this.add(ps, signature);
    }

    public boolean add(Tuple ps, Tuple signature) {
        boolean change;
        Object old = this.matchings.get(signature);
        boolean bl = change = old == null;
        if (change) {
            this.matchings.put(signature, ps);
        } else {
            CollectionsFactory.MarkedSet coll;
            if (old instanceof CollectionsFactory.MarkedSet) {
                coll = (CollectionsFactory.MarkedSet)old;
            } else {
                coll = CollectionsFactory.createMarkedSet();
                coll.add((Object)((Tuple)old));
                this.matchings.put(signature, coll);
            }
            if (!coll.add((Object)ps)) {
                throw new IllegalStateException(String.format("Duplicate insertion of tuple %s into node %s", ps, this.owner));
            }
        }
        return change;
    }

    public boolean remove(Tuple ps) {
        Tuple signature = this.mask.transform((ITuple)ps);
        return this.remove(ps, signature);
    }

    public boolean remove(Tuple ps, Tuple signature) {
        Object old = this.matchings.get(signature);
        if (old instanceof CollectionsFactory.MarkedSet) {
            CollectionsFactory.MarkedSet coll = (CollectionsFactory.MarkedSet)old;
            if (coll.remove((Object)ps)) {
                if (1 == coll.size()) {
                    Tuple remainingSingleton = (Tuple)coll.iterator().next();
                    this.matchings.put(signature, remainingSingleton);
                }
                return false;
            }
        } else if (ps.equals(old)) {
            this.matchings.remove(signature);
            return true;
        }
        throw new IllegalStateException(String.format("Duplicate deletion of tuple %s from node %s", ps, this.owner));
    }

    public Collection<Tuple> get(Tuple signature) {
        Object bucket = this.matchings.get(signature);
        if (bucket instanceof CollectionsFactory.MarkedSet) {
            return (CollectionsFactory.MarkedSet)bucket;
        }
        if (bucket == null) {
            return null;
        }
        return Collections.singleton((Tuple)bucket);
    }

    public void clear() {
        this.matchings.clear();
    }

    public Collection<Tuple> getSignatures() {
        return this.matchings.keySet();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new MaskedPatternIterator(this);
    }

    public String toString() {
        return "MTM<" + this.mask + "|" + this.matchings + ">";
    }

    public int getTotalSize() {
        int i = 0;
        for (Object v : this.matchings.values()) {
            if (v instanceof CollectionsFactory.MarkedSet) {
                i += ((CollectionsFactory.MarkedSet)v).size();
                continue;
            }
            ++i;
        }
        return i;
    }

    public int getKeysetSize() {
        return this.matchings.keySet().size();
    }

    public Node getOwner() {
        return this.owner;
    }

    class MaskedPatternIterator
    implements Iterator<Tuple> {
        Iterator<Object> signatureGroup;
        Iterator<Tuple> element;

        public MaskedPatternIterator(MaskedTupleMemory memory) {
            this.signatureGroup = memory.matchings.values().iterator();
            this.element = EMPTY_ITERATOR;
        }

        @Override
        public boolean hasNext() {
            return this.element.hasNext() || this.signatureGroup.hasNext();
        }

        @Override
        public Tuple next() throws NoSuchElementException {
            if (this.element.hasNext()) {
                return this.element.next();
            }
            if (this.signatureGroup.hasNext()) {
                Object bucket = this.signatureGroup.next();
                if (bucket instanceof CollectionsFactory.MarkedSet) {
                    this.element = ((CollectionsFactory.MarkedSet)bucket).iterator();
                    return this.element.next();
                }
                this.element = EMPTY_ITERATOR;
                return (Tuple)bucket;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

