/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IDeltaBag;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;

public class DefaultMailbox
implements Mailbox {
    private static final int SIZE_THRESHOLD = 32;
    protected IDeltaBag<Tuple> queue;
    protected IDeltaBag<Tuple> buffer;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected boolean delivering;
    protected final CommunicationTracker tracker;
    protected boolean fallThrough = false;
    protected CommunicationGroup currentGroup = null;
    private boolean queueSizeTresholdExceeded = false;
    private boolean bufferSizeTresholdExceeded = false;

    public DefaultMailbox() {
        this(null, null);
    }

    public DefaultMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.tracker = container == null ? null : container.getTracker();
        this.queue = CollectionsFactory.createDeltaBag();
        this.buffer = CollectionsFactory.createDeltaBag();
    }

    protected IDeltaBag<Tuple> getActiveQueue() {
        if (this.delivering) {
            return this.buffer;
        }
        return this.queue;
    }

    protected Integer get(Tuple key) {
        return this.getActiveQueue().getCount((Object)key);
    }

    protected boolean isEmpty() {
        return this.getActiveQueue().isEmpty();
    }

    protected Set<Tuple> keySet() {
        return this.getActiveQueue().keySet();
    }

    @Override
    public void postMessage(Direction direction, Tuple update) {
        if (this.fallThrough) {
            this.receiver.update(direction, update);
        } else {
            this.enqueue(direction, update);
        }
    }

    private void enqueue(Direction direction, Tuple update) {
        IDeltaBag<Tuple> activeQueue = this.getActiveQueue();
        boolean wasEmpty = activeQueue.isEmpty();
        boolean significantChange = direction == Direction.REVOKE ? activeQueue.removeOne((Object)update) : activeQueue.addOne((Object)update);
        if (significantChange) {
            if (this.delivering) {
                this.bufferSizeTresholdExceeded = this.bufferSizeTresholdExceeded || activeQueue.size() == 32;
            } else {
                boolean bl = this.queueSizeTresholdExceeded = this.queueSizeTresholdExceeded || activeQueue.size() == 32;
            }
            if (this.container != null) {
                if (wasEmpty) {
                    this.currentGroup.notifyHasMessage(this, MessageKind.DEFAULT);
                } else if (activeQueue.isEmpty()) {
                    this.currentGroup.notifyLostAllMessages(this, MessageKind.DEFAULT);
                }
            }
        }
    }

    @Override
    public void deliverAll(MessageKind kind) {
        this.delivering = true;
        for (Tuple tuple : this.queue) {
            Direction direction;
            int count = this.queue.getCount((Object)tuple);
            if (count < 0) {
                direction = Direction.REVOKE;
                count = -count;
            } else {
                direction = Direction.INSERT;
            }
            int i = 0;
            while (i < count) {
                this.receiver.update(direction, tuple);
                ++i;
            }
        }
        this.delivering = false;
        if (this.queueSizeTresholdExceeded) {
            this.queue = this.buffer;
            this.buffer = CollectionsFactory.createDeltaBag();
        } else {
            this.queue.clear();
            IDeltaBag<Tuple> tmpQueue = this.queue;
            this.queue = this.buffer;
            this.buffer = tmpQueue;
        }
        this.queueSizeTresholdExceeded = this.bufferSizeTresholdExceeded;
        this.bufferSizeTresholdExceeded = false;
    }

    public String toString() {
        return "MBOX (" + this.receiver + ") " + this.queue;
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.queue.clear();
        this.buffer.clear();
    }

    public boolean isFallThrough() {
        return this.fallThrough;
    }

    public void setFallThrough(boolean fallThrough) {
        this.fallThrough = fallThrough;
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup currentGroup) {
        this.currentGroup = currentGroup;
    }
}

