/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictSet;
import org.eclipse.viatra.transformation.evm.specific.resolver.ReconfigurableConflictResolver;

public class FixedPriorityConflictResolver
extends ReconfigurableConflictResolver<FixedPriorityConflictSet> {
    protected Map<RuleSpecification<?>, Integer> priorities = new HashMap();

    public void setPriority(RuleSpecification<?> specification, int priority) {
        Preconditions.checkArgument((specification != null ? 1 : 0) != 0, (String)"Specification cannot be null!");
        Integer oldPriority = this.priorities.get(specification);
        if (oldPriority != null && oldPriority == priority) {
            return;
        }
        this.priorities.put(specification, priority);
        Set sets = this.getConflictSets();
        for (WeakReference weakReference : sets) {
            FixedPriorityConflictSet conflictSet = (FixedPriorityConflictSet)weakReference.get();
            if (conflictSet == null) continue;
            conflictSet.setPriority(specification, priority);
        }
    }

    @Override
    protected FixedPriorityConflictSet createReconfigurableConflictSet() {
        return new FixedPriorityConflictSet(this, this.priorities);
    }
}

