/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class SingleTableMultitenantPolicy
implements MultitenantPolicy {
    protected boolean includeTenantCriteria;
    protected ClassDescriptor descriptor;
    protected Map<DatabaseField, String> tenantDiscriminatorFields;
    protected Map<String, List<DatabaseField>> tenantDiscriminatorFieldsKeyedOnContext;

    public SingleTableMultitenantPolicy(ClassDescriptor desc) {
        this.descriptor = desc;
        this.includeTenantCriteria = true;
        this.tenantDiscriminatorFields = new HashMap<DatabaseField, String>(5);
        this.tenantDiscriminatorFieldsKeyedOnContext = new HashMap<String, List<DatabaseField>>(5);
    }

    @Override
    public void addFieldsToRow(AbstractRecord row, AbstractSession session) {
        for (DatabaseField discriminatorField : this.tenantDiscriminatorFields.keySet()) {
            String property = this.tenantDiscriminatorFields.get(discriminatorField);
            Object propertyValue = session.getProperty(property);
            row.put(discriminatorField, propertyValue);
        }
    }

    @Override
    public void addToTableDefinition(TableDefinition tableDefinition) {
    }

    @Override
    public MultitenantPolicy clone(ClassDescriptor descriptor) {
        SingleTableMultitenantPolicy clonedPolicy = new SingleTableMultitenantPolicy(descriptor);
        clonedPolicy.includeTenantCriteria = this.includeTenantCriteria;
        clonedPolicy.tenantDiscriminatorFields = this.tenantDiscriminatorFields;
        return clonedPolicy;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void addTenantDiscriminatorField(String property, DatabaseField field) {
        if (this.tenantDiscriminatorFields.containsKey(field)) {
            String currentProperty = this.tenantDiscriminatorFields.get(field);
            if (!currentProperty.equals(property)) {
                throw ValidationException.multipleContextPropertiesForSameTenantDiscriminatorFieldSpecified(this.getDescriptor().getJavaClassName(), field.getQualifiedName(), currentProperty, property);
            }
        } else {
            this.tenantDiscriminatorFields.put(field, property);
            if (!this.tenantDiscriminatorFieldsKeyedOnContext.containsKey(property)) {
                this.tenantDiscriminatorFieldsKeyedOnContext.put(property, new ArrayList());
            }
            this.tenantDiscriminatorFieldsKeyedOnContext.get(property).add(field);
        }
    }

    public Map<DatabaseField, String> getTenantDiscriminatorFields() {
        return this.tenantDiscriminatorFields;
    }

    public Map<String, List<DatabaseField>> getTenantDiscriminatorFieldsKeyedOnContext() {
        return this.tenantDiscriminatorFieldsKeyedOnContext;
    }

    public boolean hasTenantDiscriminatorFields() {
        return !this.tenantDiscriminatorFields.isEmpty();
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.hasTenantDiscriminatorFields()) {
            for (DatabaseField discriminatorField : this.tenantDiscriminatorFields.keySet()) {
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForField(discriminatorField);
                if (mapping != null && !mapping.isReadOnly() && !mapping.isMultitenantPrimaryKeyMapping()) {
                    throw ValidationException.nonReadOnlyMappedTenantDiscriminatorField(this.getDescriptor().getJavaClassName(), discriminatorField.getQualifiedName());
                }
                session.addMultitenantContextProperty(this.tenantDiscriminatorFields.get(discriminatorField));
            }
        }
    }

    @Override
    public boolean isSingleTableMultitenantPolicy() {
        return true;
    }

    @Override
    public boolean isTablePerMultitenantPolicy() {
        return false;
    }

    @Override
    public void postInitialize(AbstractSession session) {
        if (this.includeTenantCriteria) {
            Expression expression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            ExpressionBuilder builder = expression == null ? new ExpressionBuilder() : expression.getBuilder();
            for (DatabaseField discriminatorField : this.tenantDiscriminatorFields.keySet()) {
                String property = this.tenantDiscriminatorFields.get(discriminatorField);
                DatabaseField newField = new DatabaseField();
                newField.setName(property, session.getPlatform());
                Expression tenantIdExpression = builder.and(builder.getField(discriminatorField).equal(builder.getProperty(newField)));
                expression = expression == null ? tenantIdExpression : expression.and(tenantIdExpression);
            }
            this.getDescriptor().getQueryManager().setAdditionalJoinExpression(expression);
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        for (DatabaseField discriminatorField : this.tenantDiscriminatorFields.keySet()) {
            this.getDescriptor().getFields().add(this.getDescriptor().buildField(discriminatorField));
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setIncludeTenantCriteria(boolean includeTenantCriteria) {
        this.includeTenantCriteria = includeTenantCriteria;
    }

    public void setTenantDiscriminatorFields(Map<DatabaseField, String> tenantDiscriminatorFields) {
        this.tenantDiscriminatorFields = tenantDiscriminatorFields;
    }
}

