/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.bundle;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.ArtifactState;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.SpringContextAccessor;
import org.eclipse.virgo.kernel.model.internal.bundle.NativeBundleArtifact;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelBundleListener
implements SynchronousBundleListener {
    private final Logger logger;
    private final BundleContext bundleContext;
    private final RuntimeArtifactRepository artifactRepository;
    private final PackageAdminUtil packageAdminUtil;
    private final RegionDigraph regionDigraph;
    private final SpringContextAccessor springContextAccessor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ModelBundleListener(@NonNull BundleContext bundleContext, @NonNull RuntimeArtifactRepository artifactRepository, @NonNull PackageAdminUtil packageAdminUtil, @NonNull RegionDigraph regionDigraph, @NonNull SpringContextAccessor springContextAccessor) {
        SpringContextAccessor springContextAccessor2 = springContextAccessor;
        RegionDigraph regionDigraph2 = regionDigraph;
        PackageAdminUtil packageAdminUtil2 = packageAdminUtil;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)packageAdminUtil2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)regionDigraph2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)springContextAccessor2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.bundleContext = bundleContext;
            this.artifactRepository = artifactRepository;
            this.packageAdminUtil = packageAdminUtil;
            this.regionDigraph = regionDigraph;
            this.springContextAccessor = springContextAccessor;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void bundleChanged(BundleEvent event) {
        try {
            try {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                if (1 == event.getType()) {
                    this.processInstalled(event);
                } else if (16 == event.getType()) {
                    this.processUninstalled(event);
                }
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processInstalled(BundleEvent event) {
        try {
            try {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                Bundle bundle = event.getBundle();
                Region region = this.regionDigraph.getRegion(bundle);
                this.logger.info("Processing installed event for bundle '{}:{}' in region '{}'", new Object[]{bundle.getSymbolicName(), bundle.getVersion().toString(), region.getName()});
                this.artifactRepository.add(new NativeBundleArtifact(this.bundleContext, this.packageAdminUtil, bundle, region, this.springContextAccessor));
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processUninstalled(BundleEvent event) {
        try {
            try {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                Bundle bundle = event.getBundle();
                for (Artifact artifact : this.artifactRepository.getArtifacts()) {
                    NativeBundleArtifact bundleArtifact;
                    if (!artifact.getType().equals("bundle") || !artifact.getName().equals(bundle.getSymbolicName()) || !artifact.getVersion().equals((Object)bundle.getVersion()) || !(artifact instanceof NativeBundleArtifact) || ArtifactState.UNINSTALLED != (bundleArtifact = (NativeBundleArtifact)artifact).getState()) continue;
                    this.artifactRepository.remove(bundleArtifact);
                    this.logger.info("Processing uninstalled event for bundle '{}:{}' from region '{}'", new Object[]{bundleArtifact.getName(), bundleArtifact.getVersion().toString(), bundleArtifact.getRegion().getName()});
                }
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ModelBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ModelBundleListener.java", Class.forName("org.eclipse.virgo.kernel.model.internal.bundle.ModelBundleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "bundleChanged", "org.eclipse.virgo.kernel.model.internal.bundle.ModelBundleListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processInstalled", "org.eclipse.virgo.kernel.model.internal.bundle.ModelBundleListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processUninstalled", "org.eclipse.virgo.kernel.model.internal.bundle.ModelBundleListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 82);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.bundle.ModelBundleListener");
    }
}

