/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.osgi.JolokiaHttpContext;

class JolokiaAuthenticatedHttpContext
extends JolokiaHttpContext {
    private final String user;
    private final String password;
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte EQUALS_SIGN = 61;

    JolokiaAuthenticatedHttpContext(String pUser, String pPassword) {
        this.user = pUser;
        this.password = pPassword;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth = request.getHeader("Authorization");
        if (auth == null || !this.verifyAuthentication(auth, this.user, this.password)) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"jolokia\"");
            response.sendError(401);
            return false;
        }
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"Basic");
        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)this.user);
        return true;
    }

    private boolean verifyAuthentication(String pAuth, String pUser, String pPassword) {
        StringTokenizer stok = new StringTokenizer(pAuth);
        String method = stok.nextToken();
        if (!"basic".equalsIgnoreCase(method)) {
            throw new IllegalArgumentException("Only BasicAuthentication is supported");
        }
        String b64Auth = stok.nextToken();
        String auth = new String(this.decode(b64Auth));
        int p = auth.indexOf(58);
        if (p != -1) {
            String name = auth.substring(0, p);
            String pwd = auth.substring(p + 1);
            return name.trim().equals(pUser) && pwd.trim().equals(pPassword);
        }
        return false;
    }

    byte[] decode(String s) {
        byte[] inBytes;
        if (s == null) {
            throw new IllegalArgumentException("Input string was null.");
        }
        try {
            inBytes = s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            inBytes = s.getBytes();
        }
        if (inBytes.length == 0) {
            return new byte[0];
        }
        if (inBytes.length < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + inBytes.length);
        }
        return this.decodeBytes(inBytes);
    }

    private byte[] decodeBytes(byte[] pInBytes) {
        byte[] decodabet = DECODABET;
        int len34 = pInBytes.length * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = 0; i < 0 + pInBytes.length; ++i) {
            sbiCrop = (byte)(pInBytes[i] & 0x7F);
            sbiDecode = decodabet[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += JolokiaAuthenticatedHttpContext.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            throw new IllegalArgumentException(String.format("Bad Base64 input character '%d' in array position %d", pInBytes[i], i));
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        JolokiaAuthenticatedHttpContext.verifyArguments(source, srcOffset, destination, destOffset);
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    private static void verifyArguments(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source == null) {
            throw new IllegalArgumentException("Source array was null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination array was null.");
        }
        if (srcOffset < 0 || srcOffset + 3 >= source.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and still process four bytes.", source.length, srcOffset));
        }
        if (destOffset < 0 || destOffset + 2 >= destination.length) {
            throw new IllegalArgumentException(String.format("Destination array with length %d cannot have offset of %d and still store three bytes.", destination.length, destOffset));
        }
    }
}

