/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.timer;

import org.eclipse.equinox.internal.util.impl.tpt.ServiceFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.timer.TimerImpl;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.util.timer.Timer;
import org.eclipse.equinox.internal.util.timer.TimerListener;

public class TimerFactory
extends ServiceFactoryImpl
implements Timer {
    private static TimerImpl timer;

    public TimerFactory(String bundleName, ThreadPoolFactoryImpl factory, Log log) {
        super(bundleName, log);
        timer = new TimerImpl(factory);
    }

    public TimerFactory(String bundleName) {
        super(bundleName);
    }

    public Object getInstance(String bundleName) {
        if (timer == null) {
            throw new RuntimeException("ServiceFactory is currently off!");
        }
        return new TimerFactory(bundleName);
    }

    public void notifyAfterMillis(TimerListener listener, long timePeriod, int event) throws IllegalArgumentException {
        this.addNotifyListener(listener, 5, 0, timePeriod, event);
    }

    public void notifyAfterMillis(TimerListener listener, int priority, long timePeriod, int event) throws IllegalArgumentException {
        this.addNotifyListener(listener, priority, 0, timePeriod, event);
    }

    public void notifyAfter(TimerListener listener, int timePeriod, int event) throws IllegalArgumentException {
        this.addNotifyListener(listener, 5, 0, timePeriod * 1000, event);
    }

    public void notifyAfter(TimerListener listener, int priority, int timePeriod, int event) throws IllegalArgumentException {
        this.addNotifyListener(listener, priority, 0, timePeriod * 1000, event);
    }

    public void addNotifyListener(TimerListener listener, int priority, int timerType, long periodMilis, int event) {
        TimerImpl tmp = timer;
        if (tmp == null) {
            throw new RuntimeException("This is a zombie!");
        }
        tmp.addNotifyListener(listener, priority, timerType, periodMilis, event, this.bundleName);
    }

    public static void stopTimer() {
        if (timer != null) {
            timer.terminate();
            timer = null;
        }
    }

    public void removeListener(TimerListener listener, int event) {
        TimerImpl tmp = timer;
        if (tmp == null) {
            throw new RuntimeException("This is a zombie!");
        }
        tmp.removeListener(listener, event);
    }
}

