/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregionfactory;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionFactoryLogEvents;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionFactoryParserLogger;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.serviceability.Assert;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

final class PackageImportWildcardExpander {
    private static final String wildcard = "*";

    PackageImportWildcardExpander() {
    }

    static String expandPackageImportsWildcards(String userRegionImportsProperty, BundleContext systemBundleContext, EventLogger eventLogger) {
        String[] exportedPackageNames = PackageImportWildcardExpander.getExportedPackageNames(systemBundleContext);
        return PackageImportWildcardExpander.expandWildcards(userRegionImportsProperty, exportedPackageNames, eventLogger);
    }

    private static String[] getExportedPackageNames(BundleContext bundleContext) {
        HashSet<String> exportedPackageNames = new HashSet<String>();
        ExportedPackage[] exportedPackageArray = PackageImportWildcardExpander.getExportedPackages(bundleContext);
        int n = exportedPackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage exportedPackage = exportedPackageArray[n2];
            exportedPackageNames.add(exportedPackage.getName());
            ++n2;
        }
        return exportedPackageNames.toArray(new String[exportedPackageNames.size()]);
    }

    private static ExportedPackage[] getExportedPackages(BundleContext bundleContext) {
        ServiceReference paServiceReference = bundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin pa = (PackageAdmin)bundleContext.getService(paServiceReference);
        ExportedPackage[] exportedPackages = pa.getExportedPackages(null);
        Assert.notNull((Object)exportedPackages, (String)"Expected at least one exported package", (Object[])new Object[0]);
        bundleContext.ungetService(paServiceReference);
        return exportedPackages;
    }

    private static String expandWildcards(String userRegionImportsProperty, String[] exportedPackageNamess, EventLogger eventLogger) {
        DynamicImportPackage dynamicImportPackage = PackageImportWildcardExpander.representImportsAsDynamicImports(userRegionImportsProperty, eventLogger);
        return PackageImportWildcardExpander.expandWildcards(dynamicImportPackage, exportedPackageNamess, eventLogger);
    }

    private static DynamicImportPackage representImportsAsDynamicImports(String userRegionImportsProperty, EventLogger eventLogger) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("DynamicImport-Package", userRegionImportsProperty);
        BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers, (ParserLogger)new UserRegionFactoryParserLogger(eventLogger));
        return manifest.getDynamicImportPackage();
    }

    private static String expandWildcards(DynamicImportPackage dynamicImportPackage, String[] exportedPackageNames, EventLogger eventLogger) {
        StringBuffer expandedPackages = new StringBuffer();
        boolean first = true;
        List dynamicallyImportedPackages = dynamicImportPackage.getDynamicallyImportedPackages();
        for (DynamicallyImportedPackage dynamicallyImportedPackage : dynamicallyImportedPackages) {
            String possiblyWildcardedPackageName = dynamicallyImportedPackage.getPackageName();
            if (possiblyWildcardedPackageName.endsWith(wildcard)) {
                List<String> expansions = PackageImportWildcardExpander.expandWildcard(possiblyWildcardedPackageName, exportedPackageNames, eventLogger);
                for (String expansion : expansions) {
                    dynamicallyImportedPackage.setPackageName(expansion);
                    if (first) {
                        first = false;
                    } else {
                        expandedPackages.append(",");
                    }
                    expandedPackages.append(dynamicallyImportedPackage.toParseString());
                }
                continue;
            }
            if (first) {
                first = false;
            } else {
                expandedPackages.append(",");
            }
            expandedPackages.append(dynamicallyImportedPackage.toParseString());
        }
        return expandedPackages.toString();
    }

    private static List<String> expandWildcard(String wildcardedPackageName, String[] exportedPackageNames, EventLogger eventLogger) {
        ArrayList<String> expansions = new ArrayList<String>();
        String prefix = wildcardedPackageName.substring(0, wildcardedPackageName.length() - 1);
        String[] stringArray = exportedPackageNames;
        int n = exportedPackageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String exportedPackage = stringArray[n2];
            if (exportedPackage.startsWith(prefix)) {
                expansions.add(exportedPackage);
            }
            ++n2;
        }
        if (expansions.isEmpty()) {
            eventLogger.log((LogEvent)UserRegionFactoryLogEvents.REGION_IMPORT_NO_MATCH, new Object[]{wildcardedPackageName});
        }
        return expansions;
    }
}

