/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.logback;

import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.virgo.medic.log.LoggingConfiguration;
import org.eclipse.virgo.medic.log.impl.CallingBundleResolver;
import org.eclipse.virgo.medic.log.impl.config.ConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.logback.ContextSelectorDelegate;
import org.eclipse.virgo.medic.log.impl.logback.LoggerContextConfigurationFailedException;
import org.eclipse.virgo.medic.log.impl.logback.LoggerContextConfigurer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class StandardContextSelectorDelegate
implements ContextSelectorDelegate,
BundleListener {
    private final CallingBundleResolver loggingCallerLocator;
    private final Map<String, LoggerContext> loggerContexts = new HashMap<String, LoggerContext>();
    private final Map<Bundle, LoggingConfiguration> loggingConfigurations = new WeakHashMap<Bundle, LoggingConfiguration>();
    private final Object monitor = new Object();
    private final ConfigurationLocator configurationLocator;
    private final LoggerContextConfigurer configurer;
    private final Bundle medicBundle;

    public StandardContextSelectorDelegate(CallingBundleResolver loggingCallerLocator, ConfigurationLocator configurationLocator, Bundle medicBundle, LoggerContextConfigurer configurer) {
        this.loggingCallerLocator = loggingCallerLocator;
        this.configurationLocator = configurationLocator;
        this.medicBundle = medicBundle;
        this.configurer = configurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoggerContext detachLoggerContext(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.loggerContexts.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getContextNames() {
        Object object = this.monitor;
        synchronized (object) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.loggerContexts.keySet());
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoggerContext getLoggerContext() {
        Object object;
        Bundle callingBundle = this.loggingCallerLocator.getCallingBundle();
        LoggingConfiguration loggingConfiguration = null;
        if (callingBundle != null) {
            object = this.monitor;
            synchronized (object) {
                loggingConfiguration = this.loggingConfigurations.get(callingBundle);
            }
        }
        if (loggingConfiguration == null && (loggingConfiguration = this.locateConfiguration(callingBundle)) != null && callingBundle != null) {
            object = this.monitor;
            synchronized (object) {
                this.loggingConfigurations.put(callingBundle, loggingConfiguration);
            }
        }
        if (loggingConfiguration != null) {
            object = this.monitor;
            synchronized (object) {
                LoggerContext existingContext = this.loggerContexts.get(loggingConfiguration.getName());
                if (existingContext != null) {
                    return existingContext;
                }
                LoggerContext configuredContext = this.createConfiguredContext(loggingConfiguration);
                this.loggerContexts.put(loggingConfiguration.getName(), configuredContext);
                return configuredContext;
            }
        }
        return null;
    }

    private LoggingConfiguration locateConfiguration(Bundle callingBundle) {
        return this.configurationLocator.locateConfiguration(callingBundle);
    }

    private LoggerContext createConfiguredContext(LoggingConfiguration configuration) {
        LoggerContext loggerContext = new LoggerContext();
        loggerContext.setName(configuration.getName());
        try {
            this.configurer.applyConfiguration(configuration, loggerContext);
        }
        catch (LoggerContextConfigurationFailedException lccfe) {
            lccfe.printStackTrace(System.err);
        }
        return loggerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoggerContext getLoggerContext(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.loggerContexts.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureDefaultContext(LoggerContext defaultContext) {
        LoggingConfiguration configuration = this.locateConfiguration(this.medicBundle);
        if (configuration != null) {
            defaultContext.reset();
            try {
                this.configurer.applyConfiguration(configuration, defaultContext);
                Object object = this.monitor;
                synchronized (object) {
                    this.loggerContexts.put(configuration.getName(), defaultContext);
                }
            }
            catch (LoggerContextConfigurationFailedException lccfe) {
                lccfe.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (8 == event.getType()) {
            Object object = this.monitor;
            synchronized (object) {
                this.loggingConfigurations.remove(event.getBundle());
            }
        }
    }
}

