/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class JarTransformer {
    private static final String MANIFEST_VERSION_HEADER = "Manifest-Version: 1.0";
    private final JarTransformerCallback callback;

    public JarTransformer(JarTransformerCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        this.callback = callback;
    }

    public void transform(InputStream is, OutputStream stream) throws IOException {
        this.transform(is, stream, false);
    }

    public void transform(InputStream is, OutputStream stream, boolean ensureManifestIsPresent) throws IOException {
        ZipEntry entry;
        ZipInputStream zipInputStream = new ZipInputStream(is);
        JarOutputStream jos = new JarOutputStream(stream);
        boolean manifestPresent = false;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            if ("META-INF/MANIFEST.MF".equals(entryName)) {
                manifestPresent = true;
            }
            if (!entry.isDirectory()) {
                this.transformEntry(zipInputStream, entry, jos);
                continue;
            }
            jos.putNextEntry(new JarEntry(entryName));
            jos.closeEntry();
        }
        if (ensureManifestIsPresent && !manifestPresent) {
            JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
            InputStream defaultManifestStream = this.getDefaultManifestStream();
            this.transformEntry(defaultManifestStream, manifestEntry, jos);
            defaultManifestStream.close();
        }
        jos.finish();
    }

    private InputStream getDefaultManifestStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
            writer.println(MANIFEST_VERSION_HEADER);
            writer.println();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void transformEntry(InputStream inputStream, ZipEntry entry, JarOutputStream jos) throws IOException {
        if (!this.callback.transformEntry(entry.getName(), inputStream, jos)) {
            jos.putNextEntry(new JarEntry(entry.getName()));
            this.copy(inputStream, jos);
            jos.closeEntry();
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static interface JarTransformerCallback {
        public boolean transformEntry(String var1, InputStream var2, JarOutputStream var3) throws IOException;
    }
}

