/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.configurationadmin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.ArtifactState;
import org.eclipse.virgo.kernel.model.internal.AbstractArtifact;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigurationArtifact
extends AbstractArtifact {
    private final Logger logger;
    static final String TYPE = "configuration";
    private final ConfigurationAdmin configurationAdmin;
    private final String pid;

    public ConfigurationArtifact(@NonNull BundleContext bundleContext, @NonNull ConfigurationAdmin configurationAdmin, @NonNull String pid, @NonNull Region region) {
        Region region2 = region;
        String string = pid;
        ConfigurationAdmin configurationAdmin2 = configurationAdmin;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)configurationAdmin2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)string);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region2);
        super(bundleContext, TYPE, pid, Version.emptyVersion, region);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.configurationAdmin = configurationAdmin;
            this.pid = pid;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ArtifactState getState() {
        try {
            return ArtifactState.ACTIVE;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(super.getProperties());
            try {
                String bundleLocation;
                Configuration configuration = this.configurationAdmin.getConfiguration(this.pid, null);
                properties.put("Pid", configuration.getPid());
                String factoryPid = configuration.getFactoryPid();
                if (factoryPid != null) {
                    properties.put("Factory Pid", factoryPid);
                }
                if ((bundleLocation = configuration.getBundleLocation()) != null) {
                    properties.put("Bound to Bundle", bundleLocation);
                }
            }
            catch (IOException iOException) {
            }
            catch (IllegalStateException illegalStateException) {
                properties.put("ERROR", "Configuration has been deleted");
            }
            return properties;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refresh() {
        try {
            return false;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void stop() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void uninstall() {
        try {
            try {
                this.configurationAdmin.getConfiguration(this.pid, null).delete();
            }
            catch (IOException e) {
                this.logger.error("Unable to delete configuration for '{}'", (Object)this.pid);
                throw new RuntimeException(String.format("Unable to delete configuration for '%s'", this.pid), e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

