/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.StandardQuery;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.RepositoryInfo;

abstract class AbstractRepositoryInfo
implements RepositoryInfo {
    private final String name;
    private final ArtifactDescriptorDepository artifactDepository;

    public AbstractRepositoryInfo(String name, ArtifactDescriptorDepository artifactDepository) {
        this.name = name;
        this.artifactDepository = artifactDepository;
    }

    @Override
    public Set<ArtifactDescriptorSummary> getAllArtifactDescriptorSummaries() {
        Set<RepositoryAwareArtifactDescriptor> artefactDescriptors = this.artifactDepository.resolveArtifactDescriptors(Collections.emptySet());
        HashSet<ArtifactDescriptorSummary> artifactDescriptorSummaries = new HashSet<ArtifactDescriptorSummary>(artefactDescriptors.size());
        for (RepositoryAwareArtifactDescriptor artifactDescriptor : artefactDescriptors) {
            String type = artifactDescriptor.getType();
            String name = artifactDescriptor.getName();
            String version = artifactDescriptor.getVersion().toString();
            artifactDescriptorSummaries.add(new ArtifactDescriptorSummary(type, name, version));
        }
        return artifactDescriptorSummaries;
    }

    public RepositoryAwareArtifactDescriptor getArtifactDescriptor(String type, String name, String version) {
        Set<RepositoryAwareArtifactDescriptor> artefacts = new StandardQuery(this.artifactDepository, "type", type).addFilter("name", name).addFilter("version", version).run();
        if (artefacts.size() == 1) {
            return artefacts.iterator().next();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

