/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.fs.internal;

import java.io.File;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.artifact.fs.internal.FileArtifactFSEntry;

public final class DirectoryArtifactFS
implements ArtifactFS {
    private final File root;

    public DirectoryArtifactFS(File root) {
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException(String.format("File '%s' must be a directory", root.getAbsolutePath()));
        }
        this.root = root;
    }

    @Override
    public ArtifactFSEntry getEntry(String name) {
        return new FileArtifactFSEntry(this.root, new File(this.root, name));
    }

    @Override
    public File getFile() {
        return this.root;
    }

    public String toString() {
        return this.root.getAbsolutePath();
    }
}

