/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Version;

final class PlanScoper {
    private static final String SCOPE_SEPARATOR = "-";
    private List<InstallArtifact> scopeMembers;
    private final EventLogger eventLogger;
    private final Scoper scoper;
    private final ServiceScoper serviceScoper;
    private final String scopeName;
    private final Version scopeVersion;

    public PlanScoper(List<InstallArtifact> scopeMembers, String name, Version version, ScopeServiceRepository scopeServiceRepository, EventLogger eventLogger) throws DeploymentException {
        this.scopeMembers = scopeMembers;
        this.scopeName = this.createScopeName(name, version);
        this.scopeVersion = version;
        this.scoper = new Scoper(this.getBundleManifests(), this.scopeName);
        this.serviceScoper = new ServiceScoper(this.scopeName, scopeServiceRepository, eventLogger);
        this.eventLogger = eventLogger;
    }

    String getScopeName() {
        return this.scopeName;
    }

    private String createScopeName(String name, Version version) {
        String scopeName = String.valueOf(name) + SCOPE_SEPARATOR + PlanScoper.versionToShortString(version);
        return scopeName;
    }

    private List<BundleManifest> getBundleManifests() throws DeploymentException {
        ArrayList<BundleManifest> bundleManifests = new ArrayList<BundleManifest>();
        for (InstallArtifact scopeMember : this.scopeMembers) {
            if (!(scopeMember instanceof BundleInstallArtifact)) continue;
            BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)scopeMember;
            try {
                bundleManifests.add(bundleInstallArtifact.getBundleManifest());
            }
            catch (IOException e) {
                throw new DeploymentException("Cannot access bundle manifest for scoping", (Throwable)e);
            }
        }
        return bundleManifests;
    }

    void scope() throws DeploymentException {
        try {
            this.scoper.scope();
        }
        catch (Scoper.UnsupportedBundleManifestVersionException ubmve) {
            throw new FatalDeploymentException("Cannot scope a bundle which does not specify a bundle manifest version of at least " + ubmve.getLowestSupportedVersion());
        }
        catch (Scoper.DuplicateBundleSymbolicNameException dbsne) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.DUPLICATE_BSN_IN_SCOPE, (Throwable)dbsne, new Object[]{this.scopeName, this.scopeVersion, dbsne.getBundleSymbolicName()});
            throw new DeploymentException("More than one bundle in scope '" + this.scopeName + "' version '" + this.scopeVersion + "' has bundle symbolic name '" + dbsne.getBundleSymbolicName() + "'");
        }
        catch (Scoper.DuplicateExportException dee) {
            String packageName = dee.getPackageName();
            String exporters = dee.getExporters();
            this.eventLogger.log((LogEvent)DeployerLogEvents.DUPLICATE_PACKAGE_DURING_SCOPING, (Throwable)dee, new Object[]{this.scopeName, this.scopeVersion, packageName, exporters});
            throw new DeploymentException("Package '" + packageName + "' exported by more than one bundle [" + exporters + "] in scope '" + this.scopeName + "' version '" + this.scopeVersion + "'");
        }
        this.serviceScoper.scope(this.getBundleArtifacts());
    }

    private Set<ArtifactFS> getBundleArtifacts() {
        HashSet<ArtifactFS> bundleArtifacts = new HashSet<ArtifactFS>();
        for (InstallArtifact scopeMember : this.scopeMembers) {
            if (!(scopeMember instanceof BundleInstallArtifact)) continue;
            ArtifactFS artifactFS = scopeMember.getArtifactFS();
            bundleArtifacts.add(artifactFS);
        }
        return bundleArtifacts;
    }

    private static String versionToShortString(Version version) {
        String result = version.toString();
        while (result.endsWith(".0")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }
}

