/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.command;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;

public class CommandMoveServiceRefs
extends AbstractCommand {
    private EObject source_;
    private EObject target_;
    private EStructuralFeature childFeature_;
    private Object[] children_;
    private boolean isCopy_;
    private Object[] clonedChildren_;
    private EList serviceRefs;

    public CommandMoveServiceRefs(String label, String description, EObject source, EObject target, EStructuralFeature childFeature, Object[] children, boolean isCopy, EList serviceRefs) {
        super(label, description);
        this.source_ = source;
        this.target_ = target;
        this.childFeature_ = childFeature;
        this.children_ = children;
        this.isCopy_ = isCopy;
        this.clonedChildren_ = null;
        this.serviceRefs = serviceRefs;
    }

    private Object cloneObject(Object object) {
        if (object instanceof EList) {
            BasicEList clone = new BasicEList();
            Iterator it = ((EList)object).iterator();
            while (it.hasNext()) {
                clone.add(this.cloneObject(it.next()));
            }
            return clone;
        }
        if (object instanceof EObject) {
            EObject source = (EObject)object;
            EClass eClass = ((EObject)object).eClass();
            EPackage ePackage = eClass.getEPackage();
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject clone = eFactory.create(eClass);
            EList features = eClass.getEAllStructuralFeatures();
            Iterator it = features.iterator();
            while (it.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)it.next();
                if (source.eIsSet(feature)) {
                    Object clonedFeature = this.cloneObject(source.eGet(feature));
                    if (feature.isMany()) {
                        ((List)clone.eGet(feature)).addAll((List)clonedFeature);
                        continue;
                    }
                    clone.eSet(feature, clonedFeature);
                    continue;
                }
                clone.eUnset(feature);
            }
            return clone;
        }
        if (object != null) {
            return new String(object.toString());
        }
        return null;
    }

    protected boolean prepare() {
        return true;
    }

    public boolean canExecute() {
        return super.canExecute();
    }

    public void execute() {
        if (this.childFeature_.isMany()) {
            this.executeMany();
        } else {
            this.executeSingle();
        }
    }

    private void executeSingle() {
        Object child = this.source_.eGet(this.childFeature_);
        if (this.isCopy_) {
            this.target_.eSet(this.childFeature_, this.cloneObject(child));
        } else {
            this.source_.eUnset(this.childFeature_);
            this.target_.eSet(this.childFeature_, child);
        }
    }

    private void executeMany() {
        EList sourceList = this.source_ instanceof WebServicesClient ? this.serviceRefs : (EList)this.source_.eGet(this.childFeature_);
        EList targetList = this.target_ instanceof WebServicesClient ? this.serviceRefs : (EList)this.target_.eGet(this.childFeature_);
        if (this.isCopy_) {
            this.clonedChildren_ = new Object[this.children_.length];
        }
        int i = 0;
        while (i < this.children_.length) {
            int index = sourceList.indexOf(this.children_[i]);
            if (index != -1) {
                if (this.isCopy_) {
                    this.clonedChildren_[i] = this.cloneObject(this.children_[i]);
                    targetList.add(this.clonedChildren_[i]);
                } else {
                    sourceList.remove(index);
                    targetList.add(this.children_[i]);
                }
            }
            ++i;
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.childFeature_.isMany()) {
            this.undoSingle();
        } else {
            this.undoMany();
        }
    }

    private void undoSingle() {
        Object child = this.target_.eGet(this.childFeature_);
        this.target_.eUnset(this.childFeature_);
        if (!this.isCopy_) {
            this.source_.eSet(this.childFeature_, child);
        }
    }

    private void undoMany() {
        block4: {
            EList targetList;
            EList sourceList;
            block3: {
                sourceList = this.source_ instanceof WebServicesClient ? this.serviceRefs : (EList)this.source_.eGet(this.childFeature_);
                targetList = this.target_ instanceof WebServicesClient ? this.serviceRefs : (EList)this.target_.eGet(this.childFeature_);
                if (!this.isCopy_) break block3;
                if (this.clonedChildren_ == null) break block4;
                int i = 0;
                while (i < this.clonedChildren_.length) {
                    targetList.remove(this.clonedChildren_[i]);
                    ++i;
                }
                break block4;
            }
            int i = 0;
            while (i < this.children_.length) {
                int index = targetList.indexOf(this.children_[i]);
                if (index != -1) {
                    targetList.remove(index);
                    sourceList.add(this.children_[i]);
                }
                ++i;
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public Collection getResult() {
        return super.getResult();
    }

    public Collection getAffectedObjects() {
        return super.getAffectedObjects();
    }

    public void dispose() {
    }

    public Command chain(Command command) {
        return super.chain(command);
    }
}

