/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.provisional;

import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public abstract class AbstractAdapterFactory
implements INodeAdapterFactory {
    private Object fAdapterKey;
    private boolean fShouldRegisterAdapter;

    protected AbstractAdapterFactory() {
    }

    public AbstractAdapterFactory(Object adapterKey) {
        this(adapterKey, true);
    }

    public AbstractAdapterFactory(Object adapterKey, boolean registerAdapters) {
        this.fAdapterKey = adapterKey;
        this.fShouldRegisterAdapter = registerAdapters;
    }

    public INodeAdapter adapt(INodeNotifier target) {
        INodeAdapter adapter = null;
        if (target != null && (adapter = target.getExistingAdapter(this.fAdapterKey)) == null) {
            adapter = this.adaptNew(target);
        }
        return adapter;
    }

    public INodeAdapterFactory copy() {
        return this;
    }

    public boolean isFactoryForType(Object type) {
        return type.equals(this.fAdapterKey);
    }

    public void release() {
    }

    protected final void setAdapterKey(Object key) {
        if (this.fAdapterKey != null && !this.fAdapterKey.equals(key)) {
            throw new IllegalStateException("INodeAdapter Key cannot be changed.");
        }
        this.fAdapterKey = key;
    }

    protected final INodeAdapter adaptNew(INodeNotifier target) {
        INodeAdapter adapter = this.createAdapter(target);
        if (adapter != null && this.fShouldRegisterAdapter) {
            target.addAdapter(adapter);
        }
        return adapter;
    }

    protected abstract INodeAdapter createAdapter(INodeNotifier var1);

    protected final boolean isShouldRegisterAdapter() {
        return this.fShouldRegisterAdapter;
    }

    protected final void setShouldRegisterAdapter(boolean shouldRegisterAdapter) {
        this.fShouldRegisterAdapter = shouldRegisterAdapter;
    }

    protected final Object getAdapterKey() {
        return this.fAdapterKey;
    }
}

