/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenAction;
import org.eclipse.jst.j2ee.internal.actions.ComponentEditorInput;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.ejb.provider.J2EEJavaClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class OpenJ2EEResourceAction
extends AbstractOpenAction {
    public static final String ID = "org.eclipse.jst.j2ee.internal.internal.ui.actions.OpenJ2EEResourceAction";
    public static final String JAVA_EDITOR_ID = "org.eclipse.jst.j2ee.internal.internal.ejb.ui.java.EnterpriseBeanJavaEditor";
    public static final String BASE_JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    protected static IEditorDescriptor javaEditorDescriptor;
    protected static IEditorDescriptor baseJavaEditorDescriptor;

    public OpenJ2EEResourceAction() {
        super("Open");
    }

    public String getID() {
        return ID;
    }

    public static IEditorDescriptor getJavaEditorDescriptor() {
        if (javaEditorDescriptor == null) {
            javaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(JAVA_EDITOR_ID);
        }
        return javaEditorDescriptor;
    }

    public static IEditorDescriptor getBaseJavaEditorDescriptor() {
        if (baseJavaEditorDescriptor == null) {
            baseJavaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(BASE_JAVA_EDITOR_ID);
        }
        return baseJavaEditorDescriptor;
    }

    protected void openAppropriateEditor(IVirtualComponent c) {
        if (c == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            editor = page.openEditor((IEditorInput)new ComponentEditorInput(c), this.currentDescriptor.getId());
            if (editor instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IResource r) {
        if (r == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            editor = page.openEditor((IEditorInput)new FileEditorInput((IFile)r), this.currentDescriptor.getId());
            if (editor instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.srcObject instanceof J2EEJavaClassProviderHelper) {
            ((J2EEJavaClassProviderHelper)this.srcObject).openInEditor();
            return;
        }
        if (this.srcObject instanceof EObject) {
            EObject ro = (EObject)this.srcObject;
            IProject p = ProjectUtilities.getProject((EObject)ro);
            if (ro instanceof BeanLink) {
                this.openBeanLinkInJavaEditor((BeanLink)ro, p);
                return;
            }
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)this.srcObject));
            if (resource != null) {
                this.openAppropriateEditor((IResource)resource);
            } else {
                ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)ro);
                ArchiveOptions options = moduleFile.getOptions();
                if (options instanceof ComponentArchiveOptions) {
                    IVirtualComponent component = ((ComponentArchiveOptions)options).getComponent();
                    this.openAppropriateEditor(component);
                }
            }
        } else if (this.srcObject instanceof Resource) {
            this.openAppropriateEditor((IResource)WorkbenchResourceHelper.getFile((Resource)((Resource)this.srcObject)));
        }
    }

    public boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        Object obj = s.getFirstElement();
        if (obj instanceof J2EEJavaClassProviderHelper) {
            this.currentDescriptor = OpenJ2EEResourceAction.getJavaEditorDescriptor();
        } else if (obj instanceof BeanLink) {
            this.currentDescriptor = OpenJ2EEResourceAction.getBaseJavaEditorDescriptor();
        } else if (obj instanceof EObject) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IFile file = WorkbenchResourceHelper.getFile((EObject)((EObject)obj));
            if (file != null) {
                IContentType contentType = IDE.getContentType((IFile)file);
                this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
            } else {
                String name = new Path(((EObject)obj).eResource().getURI().toString()).lastSegment();
                this.currentDescriptor = registry.getDefaultEditor(name, null);
            }
        } else if (obj instanceof Resource) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IFile file = WorkbenchResourceHelper.getFile((Resource)((Resource)obj));
            IContentType contentType = IDE.getContentType((IFile)file);
            this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
        } else {
            this.currentDescriptor = null;
            return false;
        }
        this.setAttributesFromDescriptor();
        this.srcObject = obj;
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openBeanLinkInJavaEditor(BeanLink link, IProject p) {
        block18: {
            block16: {
                block15: {
                    block17: {
                        block14: {
                            block13: {
                                linkName = null;
                                javaClass = null;
                                comp = ComponentUtilities.findComponent((EObject)link);
                                if (!(link instanceof EJBLink)) break block17;
                                linkName = ((EJBLink)link).getEjbLink();
                                artifactEdit = null;
                                try {
                                    artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
                                    ejbJar = artifactEdit.getEJBJar();
                                    if (ejbJar == null) {
                                        while (true) {
                                            var9_11 = null;
                                            if (artifactEdit == null) return;
                                            break block13;
                                            break;
                                        }
                                    }
                                    if ((bean = ejbJar.getEnterpriseBeanNamed(linkName)) == null) ** continue;
                                    javaClass = bean.getEjbClass();
                                    break block14;
                                }
                                catch (Throwable var10_19) {
                                    var9_12 = null;
                                    if (artifactEdit == null) throw var10_19;
                                    artifactEdit.dispose();
                                    throw var10_19;
                                }
                            }
                            artifactEdit.dispose();
                            return;
                        }
                        var9_13 = null;
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                        break block18;
                    }
                    linkName = ((ServletLink)link).getServletLink();
                    artifactEdit = null;
                    try {
                        artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
                        webApp = artifactEdit.getWebApp();
                        if (webApp == null) {
                            while (true) {
                                var9_14 = null;
                                if (artifactEdit == null) return;
                                break block15;
                                break;
                            }
                        }
                        if ((servlet = webApp.getServletNamed(linkName)) == null) ** continue;
                        javaClass = servlet.getServletClass();
                        break block16;
                    }
                    catch (Throwable var10_20) {
                        var9_15 = null;
                        if (artifactEdit == null) throw var10_20;
                        artifactEdit.dispose();
                        throw var10_20;
                    }
                }
                artifactEdit.dispose();
                return;
            }
            var9_16 = null;
            if (artifactEdit == null) break block18;
            artifactEdit.dispose();
            ** GOTO lbl-1000
        }
        try lbl-1000:
        // 2 sources

        {
            J2EEEditorUtility.openInEditor(javaClass, p);
            return;
        }
        catch (Exception cantOpen) {
            cantOpen.printStackTrace();
        }
    }

    protected EObject getRootObject(Object obj) {
        if (obj instanceof EObject) {
            EObject refObj = (EObject)obj;
            while (refObj != null && refObj.eContainer() != null) {
                refObj = refObj.eContainer();
            }
            return refObj;
        }
        return null;
    }
}

