/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class J2EEArtifactExportOperation
extends AbstractDataModelOperation {
    protected IProgressMonitor progressMonitor;
    private IVirtualComponent component;
    private IPath destinationPath;
    private ModuleFile moduleFile;
    private boolean exportSource = false;
    protected final int REFRESH_WORK = 100;
    protected final int JAVA_BUILDER_WORK = 100;
    protected final int LIB_BUILDER_WORK = 100;
    protected final int EXPORT_WORK = 1000;
    protected final int CLOSE_WORK = 10;

    public J2EEArtifactExportOperation() {
    }

    public J2EEArtifactExportOperation(IDataModel model) {
        super(model);
    }

    protected int computeTotalWork() {
        int totalWork = 100;
        if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            totalWork += 200;
        }
        return totalWork += 1010;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.setComponent((IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT"));
        this.setDestinationPath((IPath)new Path(this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")));
        this.setExportSource(this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES"));
        try {
            try {
                monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Exporting_archive, new Object[]{this.getDestinationPath().lastSegment()}), this.computeTotalWork());
                this.setProgressMonitor(monitor);
                this.component.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
                    this.runNecessaryBuilders(this.component, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                }
                this.export();
            }
            catch (Exception e) {
                if (this.moduleFile == null) throw new ExecutionException(String.valueOf(EJBArchiveOpsResourceHandler.Error_exporting__UI_) + this.archiveString(), (Throwable)e);
                this.moduleFile.close();
                monitor.worked(10);
                throw new ExecutionException(String.valueOf(EJBArchiveOpsResourceHandler.Error_exporting__UI_) + this.archiveString(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        return OK_STATUS;
    }

    protected abstract void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException;

    protected abstract String archiveString();

    protected void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private void setComponent(IVirtualComponent newComponent) {
        this.component = newComponent;
    }

    protected IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        }
        return this.component;
    }

    protected IPath getDestinationPath() {
        return this.destinationPath;
    }

    protected void setDestinationPath(IPath newDestinationPath) {
        this.destinationPath = newDestinationPath;
    }

    protected boolean isExportSource() {
        return this.exportSource;
    }

    protected void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    protected ModuleFile getModuleFile() {
        return this.moduleFile;
    }

    protected void setModuleFile(ModuleFile newModuleFile) {
        this.moduleFile = newModuleFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runNecessaryBuilders(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(null, 200);
            if (!component.isBinary()) {
                ICommand libCopyBuilder;
                IProject project = component.getProject();
                IProjectDescription description = project.getDescription();
                ICommand javaBuilder = this.getJavaCommand(description);
                if (javaBuilder != null) {
                    project.build(10, "org.eclipse.jdt.core.javabuilder", javaBuilder.getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                if ((libCopyBuilder = this.getLibCopyBuilder(description)) != null) {
                    project.build(10, "org.eclipse.jst.j2ee.LibCopyBuilder", libCopyBuilder.getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    protected ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected ICommand getLibCopyBuilder(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jst.j2ee.LibCopyBuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        Set projs = this.gatherDependentProjects(this.getComponent(), new HashSet());
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator iter = projs.iterator();
        while (iter.hasNext()) {
            IProject proj = (IProject)iter.next();
            ISchedulingRule rule = ruleFactory.createRule((IResource)proj);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)combinedRule);
        }
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.buildRule(), combinedRule);
        return combinedRule;
    }

    private Set gatherDependentProjects(IVirtualComponent comp, Set projs) {
        if (!projs.contains(comp.getProject())) {
            projs.add(comp.getProject());
            IVirtualReference[] refs = comp.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference refComp = refs[i];
                projs.addAll(this.gatherDependentProjects(refComp.getReferencedComponent(), projs));
                ++i;
            }
        }
        return projs;
    }
}

