/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.PropertiesResourceFilter;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class TableViewerWidget
extends SimpleWidgetDataContributor {
    private int DEFAULT_TABLE_HEIGHT_HINT = 100;
    private int DEFAULT_COLUMN_WIDTH = 80;
    public static byte MAP_ONE_TO_ONE = (byte)3;
    public static byte MAP_MANY_TO_ONE = 1;
    public static byte MAP_MANY_TO_MANY = 0;
    private String[] columns_;
    private TableViewer tableViewer_;
    private Table table_;
    private TableEditor editor_;
    private TableEditorListener tableEditorListener_;
    private Text text_;
    private Button import_;
    private Button add_;
    private Button remove_;
    private Composite parent_;
    private Listener statusListener_;
    private String message = null;
    private byte rescriction = MAP_MANY_TO_MANY;
    private List values_;
    private Object defaultValue_;
    private PropertiesResourceFilter filter_ = new PropertiesResourceFilter();

    public TableViewerWidget(String[] columns, List initValues, Object defaultValue, byte rescriction) {
        this.columns_ = columns;
        this.values_ = new ArrayList();
        if (initValues != null && initValues.size() > 0) {
            this.values_.addAll(initValues);
        }
        this.defaultValue_ = defaultValue != null ? defaultValue : new String("");
        this.rescriction = rescriction;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(768));
        this.table_ = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = this.DEFAULT_TABLE_HEIGHT_HINT;
        this.table_.setLayoutData((Object)gd);
        this.table_.setHeaderVisible(true);
        this.table_.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int maxWidth = this.DEFAULT_COLUMN_WIDTH;
        int i = 0;
        while (i < this.columns_.length) {
            TableColumn tableColumn = new TableColumn(this.table_, 0);
            tableColumn.setText(this.columns_[i]);
            tableColumn.pack();
            int tableColumnWidth = Math.max(this.DEFAULT_COLUMN_WIDTH, tableColumn.getWidth());
            maxWidth = Math.max(maxWidth, tableColumnWidth);
            ColumnWeightData columnData = new ColumnWeightData(tableColumnWidth, tableColumnWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        this.table_.setLayout((Layout)tableLayout);
        this.editor_ = new TableEditor(this.table_);
        this.editor_.horizontalAlignment = 16384;
        this.editor_.grabHorizontal = true;
        this.editor_.minimumWidth = maxWidth;
        this.tableEditorListener_ = new TableEditorListener();
        this.table_.addMouseListener((MouseListener)this.tableEditorListener_);
        this.tableViewer_ = new TableViewer(this.table_);
        this.tableViewer_.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char asciiDel = e.character;
                if (asciiDel == '\u007f') {
                    TableViewerWidget.this.handleDeleteKeyPressed();
                }
                if (e.character == '\r' || e.character == ' ') {
                    TableViewerWidget.this.tableEditorListener_.editSelection();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tableViewer_.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer_.setInput((Object)this.values_);
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewerWidget.this.enableRemove(true);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(544));
        this.import_ = new Button(buttonComposite, 8);
        this.import_.setText(ConsumptionUIMessages.LABEL_IMPORT);
        this.import_.setLayoutData((Object)new GridData(256));
        this.import_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerWidget.this.handleImportButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.add_ = new Button(buttonComposite, 8);
        this.add_.setText(ConsumptionUIMessages.LABEL_ADD);
        this.add_.setLayoutData((Object)new GridData(256));
        this.add_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerWidget.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.remove_ = new Button(buttonComposite, 8);
        this.remove_.setText(ConsumptionUIMessages.LABEL_REMOVE);
        this.remove_.setLayoutData((Object)new GridData(256));
        this.remove_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerWidget.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enableRemove(false);
        return this;
    }

    private void enableRemove(boolean enabled) {
        this.remove_.setEnabled(enabled && !this.tableViewer_.getSelection().isEmpty());
    }

    private void handleImportButtonSelected(SelectionEvent event) {
        IResource resource = DialogUtils.browseResources((Shell)this.parent_.getShell(), (IResource)ResourceUtils.getWorkspaceRoot(), null, (Filter)this.filter_);
        if (resource != null && resource instanceof IFile) {
            try {
                Properties props = new Properties();
                props.load(((IFile)resource).getContents());
                Set<Map.Entry<Object, Object>> set = props.entrySet();
                LinkedList<String[]> list = new LinkedList<String[]>();
                Iterator<Map.Entry<Object, Object>> i = set.iterator();
                while (i.hasNext()) {
                    Map.Entry<Object, Object> me = i.next();
                    String key = (String)me.getKey();
                    String val = (String)me.getValue();
                    list.add(new String[]{key, val});
                }
                this.values_.addAll(list);
            }
            catch (Exception exception) {}
        }
        this.refresh();
    }

    private void handleAddButtonSelected(SelectionEvent event) {
        this.values_.add(this.defaultValue_);
        this.refresh();
        this.setSelectionAsObject(this.values_.get(this.table_.getItemCount() - 1));
        this.tableEditorListener_.editSelection();
    }

    private void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    private void handleDeleteKeyPressed() {
        this.internalDispose();
        ISelection selection = this.tableViewer_.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            int selectionIndex = this.table_.getSelectionIndex();
            int selectionCount = this.table_.getItemCount();
            this.values_.remove(selectionIndex);
            if (selectionIndex < selectionCount - 1) {
                this.setSelectionAsObject(this.values_.get(selectionIndex));
            } else if (selectionCount - 2 >= 0) {
                this.setSelectionAsObject(this.values_.get(selectionCount - 2));
            }
            this.refresh();
        }
    }

    private void internalRefresh() {
        if (this.text_ != null) {
            TableItem oldTableItem = this.editor_.getItem();
            int oldColumnIndex = this.editor_.getColumn();
            if (oldTableItem != null && oldColumnIndex >= 0 && oldColumnIndex < this.columns_.length) {
                String oldText = this.text_.getText();
                oldTableItem.setText(oldColumnIndex, oldText);
                int oldRowIndex = this.table_.indexOf(oldTableItem);
                this.values_.set(oldRowIndex, new String[]{oldTableItem.getText(0), oldTableItem.getText(1)});
            }
        }
        this.checkMappingConstraints();
        this.statusListener_.handleEvent(null);
    }

    private void checkMappingConstraints() {
        HashMap<String, String> map = new HashMap<String, String>();
        int cnt = 0;
        while (cnt < this.values_.size()) {
            String[] value = (String[])this.values_.get(cnt);
            if (map.containsKey(value[0]) && (this.rescriction & 1) != 0) {
                this.message = NLS.bind((String)ConsumptionUIMessages.MSG_MAPPING_DUPLICATE_ENTRIES, (Object[])new String[]{this.columns_[0], this.columns_[1]});
                return;
            }
            if (map.containsValue(value[1]) && (this.rescriction & 2) != 0) {
                this.message = NLS.bind((String)ConsumptionUIMessages.MSG_MAPPING_DUPLICATE_ENTRIES, (Object[])new String[]{this.columns_[1], this.columns_[0]});
                return;
            }
            map.put(value[0], value[1]);
            ++cnt;
        }
        this.message = null;
    }

    public IStatus getStatus() {
        return this.message == null ? Status.OK_STATUS : StatusUtils.errorStatus((String)this.message);
    }

    private void setSelectionAsObject(Object object) {
        this.tableViewer_.setSelection((ISelection)new StructuredSelection(object), true);
    }

    public void refresh() {
        this.internalRefresh();
        this.tableViewer_.refresh();
    }

    public TableItem[] getItems() {
        return this.table_.getItems();
    }

    public void setEnabled(boolean enabled) {
        this.add_.setEnabled(enabled);
        this.enableRemove(enabled);
    }

    public void dispose() {
        this.internalDispose();
        if (this.editor_ != null) {
            this.editor_.dispose();
        }
        if (this.table_ != null) {
            this.table_.dispose();
        }
        if (this.add_ != null) {
            this.add_.dispose();
        }
        if (this.remove_ != null) {
            this.remove_.dispose();
        }
    }

    private void internalDispose() {
        if (this.text_ != null) {
            this.text_.dispose();
        }
        this.text_ = null;
    }

    protected class TableEditorListener
    implements MouseListener {
        private int currSelectionIndex_ = -1;
        private int editRow_ = -1;
        private int editColumn_ = -1;

        public void mouseDoubleClick(MouseEvent e) {
            this.mouseDown(e);
        }

        public void mouseDown(MouseEvent e) {
            TableViewerWidget.this.internalRefresh();
            TableViewerWidget.this.internalDispose();
            if (TableViewerWidget.this.table_.isFocusControl()) {
                TableItem tableItem;
                int selectedColumnIndex;
                int selectedRowIndex = this.getSelectedRow(TableViewerWidget.this.table_, e.y);
                if (this.currSelectionIndex_ != -1 && selectedRowIndex != -1 && this.currSelectionIndex_ == selectedRowIndex && (selectedColumnIndex = this.getSelectedColumn(tableItem = TableViewerWidget.this.table_.getItem(selectedRowIndex), e.x, e.y)) != -1 && (TableViewerWidget.this.text_ == null || TableViewerWidget.this.text_.isDisposed() || selectedColumnIndex != TableViewerWidget.this.editor_.getColumn())) {
                    this.editSelection(selectedRowIndex, selectedColumnIndex);
                }
                this.currSelectionIndex_ = selectedRowIndex;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        private int getSelectedRow(Table table, int y) {
            TableItem[] tableItems = table.getItems();
            int i = 0;
            while (i < tableItems.length) {
                Rectangle rectangle = tableItems[i].getBounds(0);
                if (rectangle != null && y >= rectangle.y && y < rectangle.y + rectangle.height) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int getSelectedColumn(TableItem tableItem, int x, int y) {
            int i = 0;
            while (i < TableViewerWidget.this.columns_.length) {
                if (tableItem.getBounds(i).contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void editSelection(int row, int column) {
            this.editRow_ = row;
            this.editColumn_ = column;
            TableItem tableItem = TableViewerWidget.this.table_.getItem(row);
            TableViewerWidget.this.text_ = new Text((Composite)TableViewerWidget.this.table_, 0);
            String text = tableItem.getText(column);
            TableViewerWidget.this.text_.setText(text != null ? text : "");
            TableViewerWidget.this.text_.addKeyListener(new KeyListener(this){
                final /* synthetic */ TableEditorListener this$1;
                {
                    this.this$1 = tableEditorListener;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u001b') {
                        this.this$1.cancelSelection();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            TableViewerWidget.this.text_.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ TableEditorListener this$1;
                {
                    this.this$1 = tableEditorListener;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16) {
                        this.this$1.traverseTabNext();
                    } else if (e.detail == 8) {
                        this.this$1.traverseTabPrevious();
                    }
                }
            });
            TableViewerWidget.this.text_.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ TableEditorListener this$1;
                {
                    this.this$1 = tableEditorListener;
                }

                public void focusLost(FocusEvent e) {
                    TableViewerWidget.access$0(TableEditorListener.access$0(this.this$1));
                }
            });
            TableViewerWidget.this.editor_.setEditor((Control)TableViewerWidget.this.text_, tableItem, column);
            TableViewerWidget.this.text_.setFocus();
            TableViewerWidget.this.text_.selectAll();
        }

        protected void traverseTabNext() {
            TableViewerWidget.this.internalRefresh();
            TableViewerWidget.this.internalDispose();
            if (this.editRow_ != TableViewerWidget.this.table_.getItems().length - 1 || this.editColumn_ != TableViewerWidget.this.columns_.length - 1) {
                if (this.editColumn_ < TableViewerWidget.this.columns_.length - 1) {
                    ++this.editColumn_;
                } else {
                    this.editColumn_ = 0;
                    ++this.editRow_;
                    TableViewerWidget.this.table_.select(this.editRow_);
                }
                this.editSelection(this.editRow_, this.editColumn_);
            }
        }

        protected void traverseTabPrevious() {
            TableViewerWidget.this.internalRefresh();
            TableViewerWidget.this.internalDispose();
            if (this.editRow_ != 0 || this.editColumn_ != 0) {
                if (this.editColumn_ > 0) {
                    --this.editColumn_;
                } else {
                    this.editColumn_ = TableViewerWidget.this.columns_.length - 1;
                    --this.editRow_;
                    TableViewerWidget.this.table_.select(this.editRow_);
                }
                this.editSelection(this.editRow_, this.editColumn_);
            }
        }

        public void cancelSelection() {
            TableViewerWidget.this.internalDispose();
            TableViewerWidget.this.internalRefresh();
        }

        public void editSelection() {
            int selectedRowIndex = TableViewerWidget.this.table_.getSelectionIndex();
            if (selectedRowIndex != -1 && TableViewerWidget.this.columns_.length > 0) {
                TableViewerWidget.this.internalRefresh();
                TableViewerWidget.this.internalDispose();
                this.editSelection(selectedRowIndex, 0);
            }
            this.currSelectionIndex_ = selectedRowIndex;
        }

        static /* synthetic */ TableViewerWidget access$0(TableEditorListener tableEditorListener) {
            return tableEditorListener.TableViewerWidget.this;
        }
    }

    protected class ListContentProvider
    implements IStructuredContentProvider {
        protected ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            TableViewerWidget.this.tableViewer_.add(this.getElements(newInput));
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                Object[] objects = new Object[list.size()];
                int i = 0;
                while (i < objects.length) {
                    objects[i] = list.get(i);
                    ++i;
                }
                return objects;
            }
            return new Object[0];
        }
    }

    protected class ListLabelProvider
    implements ITableLabelProvider {
        protected ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((String[])element)[columnIndex];
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }
    }
}

