/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel.chtml;

import java.util.Hashtable;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.chtml.HTMLElemDeclImpl;
import org.eclipse.wst.html.core.internal.contentmodel.chtml.PropertyProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.AnnotationMap;

final class PropertyProviderFactory {
    private static PropertyProviderFactory instance = null;
    private Hashtable registry = new Hashtable();
    private PropertyProvider defaultProvider = new DefaultProvider();

    public static PropertyProvider getProvider(String propName) {
        PropertyProviderFactory factory = PropertyProviderFactory.getInstance();
        PropertyProvider pp = (PropertyProvider)factory.registry.get(propName);
        if (pp != null) {
            return pp;
        }
        pp = factory.create(propName);
        if (pp == null) {
            return factory.defaultProvider;
        }
        factory.registry.put(propName, pp);
        return pp;
    }

    private static synchronized PropertyProviderFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new PropertyProviderFactory();
        return instance;
    }

    private PropertyProviderFactory() {
    }

    private PropertyProvider create(String propName) {
        AbstractElementPropertyProvider pp = null;
        if (propName.equals("isJSP")) {
            pp = new PPIsJSP();
        } else if (propName.equals("isXHTML")) {
            pp = new PPIsXHTML();
        } else if (propName.equals("isSSI")) {
            pp = new PPIsSSI();
        } else if (propName.equals("layoutType")) {
            pp = new PPLayoutType();
        } else if (propName.equals("lineBreakHint")) {
            pp = new PPLineBreakHint();
        } else if (propName.equals("prohibitedAncestors")) {
            pp = new PPProhibitedAncestors();
        } else if (propName.equals("shouldKeepSpace")) {
            pp = new PPShouldKeepSpace();
        } else if (propName.equals("shouldIndentChildSource")) {
            pp = new PPShouldIndentChildSource();
        } else if (propName.equals("terminators")) {
            pp = new PPTerminators();
        } else if (propName.equals("tagInfo")) {
            pp = new PPTagInfo();
        } else if (propName.equals("omitType")) {
            pp = new PPOmitType();
        } else if (propName.equals("inclusion")) {
            pp = new PPInclusion();
        }
        return pp;
    }

    class DefaultProvider
    implements PropertyProvider {
        public boolean supports(HTMLElementDeclaration edecl) {
            return false;
        }

        public Object get(HTMLElementDeclaration edecl) {
            return null;
        }
    }

    abstract class AbstractElementPropertyProvider
    implements PropertyProvider {
        protected AbstractElementPropertyProvider() {
        }

        public boolean supports(HTMLElementDeclaration edecl) {
            return edecl != null;
        }

        public Object get(HTMLElementDeclaration edecl) {
            if (!(edecl instanceof HTMLPropertyDeclaration)) {
                return null;
            }
            return this.getElementProperty((HTMLPropertyDeclaration)((Object)edecl));
        }

        protected abstract Object getElementProperty(HTMLPropertyDeclaration var1);
    }

    class PPTagInfo
    extends AbstractElementPropertyProvider {
        private static final String htmlAnnotationLoc = "data/htmref.xml";
        protected AnnotationMap fAnnotationMap = null;

        protected AnnotationMap getAnnotationMap() {
            if (this.fAnnotationMap == null) {
                this.fAnnotationMap = new AnnotationMap();
                try {
                    this.fAnnotationMap.load(htmlAnnotationLoc, HTMLCorePlugin.getDefault().getBundle().getSymbolicName());
                }
                catch (Exception exception) {}
            }
            return this.fAnnotationMap;
        }

        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            if (decl instanceof HTMLElementDeclaration) {
                return this.getAnnotationMap().getProperty(((HTMLElementDeclaration)((Object)decl)).getElementName(), "tagInfo");
            }
            return null;
        }
    }

    class PPShouldKeepSpace
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return new Boolean(decl.shouldKeepSpaces());
        }
    }

    class PPShouldIndentChildSource
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return new Boolean(decl.shouldIndentChildSource());
        }
    }

    class PPTerminators
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            if (decl == null) {
                return null;
            }
            if (!(decl instanceof HTMLElemDeclImpl)) {
                return null;
            }
            return ((HTMLElemDeclImpl)decl).getTerminators();
        }
    }

    class PPProhibitedAncestors
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return decl.getProhibitedAncestors();
        }
    }

    class PPIsJSP
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return new Boolean(decl.isJSP());
        }
    }

    class PPIsXHTML
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return new Boolean(false);
        }
    }

    class PPIsSSI
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return new Boolean(false);
        }
    }

    class PPLineBreakHint
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            String hint = "breakNone";
            switch (decl.getLineBreakHint()) {
                case 11: {
                    hint = "breakAfterStart";
                    break;
                }
                case 12: {
                    hint = "breakBeforeStartAndAfterEnd";
                    break;
                }
            }
            return hint;
        }
    }

    class PPLayoutType
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            String type = "layoutNone";
            switch (decl.getLayoutType()) {
                case 101: {
                    type = "layoutBlock";
                    break;
                }
                case 104: {
                    type = "layoutBreak";
                    break;
                }
                case 105: {
                    type = "layoutHidden";
                    break;
                }
                case 103: {
                    type = "layoutObject";
                    break;
                }
                case 102: {
                    type = "layoutWrap";
                    break;
                }
            }
            return type;
        }
    }

    class PPOmitType
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            String type = "omitNone";
            switch (decl.getOmitType()) {
                case 1: {
                    type = "omitBoth";
                    break;
                }
                case 2: {
                    type = "omitEnd";
                    break;
                }
                case 3: {
                    type = "omitEndDefault";
                    break;
                }
                case 4: {
                    type = "omitEndMust";
                    break;
                }
            }
            return type;
        }
    }

    class PPInclusion
    extends AbstractElementPropertyProvider {
        protected Object getElementProperty(HTMLPropertyDeclaration decl) {
            return decl.getInclusion();
        }
    }
}

