/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.fe;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.DeltaDDLGeneratorWithOptions;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionID;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Constraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;

public class GenericDeltaDdlGenerator
implements DeltaDDLGeneratorWithOptions {
    protected static final int CREATE = 1;
    protected static final int DROP = 2;
    protected static final int MODIFIED = 4;
    protected static final int RENAME = 8;
    protected static final int COMMENT = 16;
    protected static final int LABEL = 32;
    protected EChangeSummary changeSummary = null;
    protected Collection redoChanges = null;
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;

    public String[] generateDeltaDDL(EChangeSummary changeSummary, SQLObject[] impacts, IProgressMonitor monitor) {
        return this.generateDeltaDDL(changeSummary, monitor);
    }

    public final String[] generateDeltaDDL(EChangeSummary changeSummary, IProgressMonitor monitor) {
        this.changeSummary = changeSummary;
        this.changeSummary.summarize();
        Map changeMap = this.buildChangeMap(monitor);
        this.analyze(changeMap);
        String[] statements = this.processChangeMap(changeMap, monitor);
        this.changeSummary = null;
        this.redoChanges = null;
        return statements;
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
            EngineeringOptionCategory general_options = null;
            int i = 0;
            while (i < this.getOptionCategories().length) {
                if (this.categories[i].getId().equals("GENERATE_OPTIONS")) {
                    general_options = this.categories[i];
                }
                ++i;
            }
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            optionVec.add(new EngineeringOption("GENERATE_FULLY_QUALIFIED_NAME", resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), true, general_options));
            optionVec.add(new EngineeringOption("GENERATE_QUOTED_IDENTIFIER", resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), true, general_options));
            Object[] options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(options);
            this.options = options;
        }
        return this.options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
            Vector<EngineeringOptionCategory> categoryVec = new Vector<EngineeringOptionCategory>();
            categoryVec.add(new EngineeringOptionCategory("GENERATE_OPTIONS", resource.getString("GENERATION_OPTIONS"), resource.getString("GENERATION_OPTIONS_DES")));
            Object[] categories = new EngineeringOptionCategory[categoryVec.size()];
            categoryVec.copyInto(categories);
            this.categories = categories;
        }
        return this.categories;
    }

    protected EngineeringOption[] getEngineeringOption() {
        return this.options;
    }

    protected void setEngineeringOption(EngineeringOption[] options) {
        this.options = options;
    }

    protected int getChangeFlag(EObject element, EObject changed, EStructuralFeature feature, ChangeSummary.Setting setting) {
        if (element != changed) {
            return 4;
        }
        if (feature == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            return 8;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Description()) {
            return 16;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Label()) {
            return 32;
        }
        if (feature == SQLTablesPackage.eINSTANCE.getTable_Columns()) {
            return 4;
        }
        if (feature instanceof EReference && feature.isMany() && ((EReference)feature).getEOpposite() != null) {
            return 0;
        }
        return 4;
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            int flag;
            EObject e = (EObject)it.next();
            if (!this.needRecreate(e, flag = ((Integer)changeMap.get(e)).intValue())) continue;
            if (e instanceof Column) {
                Column column = (Column)e;
                Table table = column.getTable();
                changeMap.put(table, new Integer(3));
                if (!(table instanceof PersistentTable)) continue;
                this.processModifiedTable((PersistentTable)table, changeMap);
                continue;
            }
            if (e instanceof PersistentTable) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedTable((PersistentTable)e, changeMap);
                continue;
            }
            if (e instanceof UniqueConstraint) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedUniqueConstraint((UniqueConstraint)e, changeMap);
                continue;
            }
            if (e instanceof Index) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedIndex((Index)e, changeMap);
                continue;
            }
            flag = 3;
            changeMap.put(e, new Integer(flag));
        }
    }

    protected boolean needRecreate(EObject e, int flag) {
        return (flag & 0xC) != 0;
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor) {
        DDLGenerator ddlGenerator = this.getDDLGenerator();
        this.undo();
        String[] drops = this.getDropStatements(ddlGenerator, changeMap, monitor);
        this.redo();
        String[] creates = this.getCreateStatements(ddlGenerator, changeMap, monitor);
        this.changeSummary = null;
        return this.merge(drops, creates);
    }

    protected final String[] merge(String[] s1, String[] s2) {
        String[] all = new String[s1.length + s2.length];
        int k = 0;
        int i = 0;
        while (i < s1.length) {
            all[k++] = s1[i];
            ++i;
        }
        i = 0;
        while (i < s2.length) {
            all[k++] = s2[i];
            ++i;
        }
        return all;
    }

    private void processModifiedUniqueConstraint(UniqueConstraint uk, Map changeMap) {
        Iterator it = uk.getForeignKey().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
    }

    private void processModifiedIndex(Index index, Map changeMap) {
        Iterator it = index.getForeignKey().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
    }

    private void processModifiedTable(PersistentTable table, Map changeMap) {
        Iterator it = table.getUniqueConstraints().iterator();
        while (it.hasNext()) {
            UniqueConstraint uk = (UniqueConstraint)it.next();
            if (changeMap.containsKey(uk)) continue;
            changeMap.put(uk, new Integer(3));
            this.processModifiedUniqueConstraint(uk, changeMap);
        }
        it = table.getIndex().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (changeMap.containsKey(index)) continue;
            changeMap.put(index, new Integer(3));
            this.processModifiedIndex(index, changeMap);
        }
        it = table.getForeignKeys().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
        it = table.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint ck = (Constraint)it.next();
            if (changeMap.containsKey(ck)) continue;
            changeMap.put(ck, new Integer(1));
        }
        it = table.getTriggers().iterator();
        while (it.hasNext()) {
            Trigger trigger = (Trigger)it.next();
            if (changeMap.containsKey(trigger)) continue;
            changeMap.put(trigger, new Integer(3));
        }
    }

    protected final void undo() {
        LinkedList<ChangeRecord> undoStack = new LinkedList<ChangeRecord>();
        LinkedList<ChangeRecord> redoStack = new LinkedList<ChangeRecord>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            List oldValues;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (oldValues = this.changeSummary.getOldValues((DataObject)(changed = (EDataObject)changedObject))) == null) continue;
            Iterator vi = oldValues.iterator();
            while (vi.hasNext()) {
                ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                EProperty p = (EProperty)changeSetting.getProperty();
                EStructuralFeature f = p.getEStructuralFeature();
                changeSetting.getValue();
                ChangeRecord c1 = new ChangeRecord();
                c1.element = changed;
                c1.feature = f;
                c1.isSet = true;
                if (f.isUnsettable()) {
                    c1.isSet = changeSetting.isSet();
                }
                if (c1.isSet) {
                    c1.value = changeSetting.getValue();
                    if (c1.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c1.value);
                        c1.value = l;
                    }
                } else {
                    c1.value = null;
                }
                undoStack.add(c1);
                ChangeRecord c2 = new ChangeRecord();
                c2.element = changed;
                c2.feature = f;
                c2.isSet = true;
                if (f.isUnsettable()) {
                    c2.isSet = changed.eIsSet(f);
                }
                if (c2.isSet) {
                    c2.value = changed.eGet(f);
                    if (c2.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c2.value);
                        c2.value = l;
                    }
                }
                redoStack.add(c2);
            }
        }
        this.executeChangeRecords(undoStack);
        this.redoChanges = redoStack;
    }

    protected final void redo() {
        this.executeChangeRecords(this.redoChanges);
    }

    protected final String[] getDropStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        DDLGenerator generator = this.getDDLGenerator();
        Vector<EObject> elements = new Vector<EObject>();
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            generator.getOptions((SQLObject[])d);
            return gen.dropSQLObjects((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers(this.getOptions()), EngineeringOptionID.generateFullyQualifiedNames(this.getOptions()), monitor);
        }
        return new String[0];
    }

    protected final String[] getCreateStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        DDLGenerator generator = this.getDDLGenerator();
        Vector<EObject> elements = new Vector<EObject>();
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 1) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            generator.getOptions((SQLObject[])d);
            return gen.createSQLObjects((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers(this.getOptions()), EngineeringOptionID.generateFullyQualifiedNames(this.getOptions()), monitor);
        }
        return new String[0];
    }

    protected final EObject getDisplayableElement(EObject e) {
        while (e != null && !ContainmentServiceImpl.INSTANCE.isDisplayableElement(e)) {
            e = ContainmentServiceImpl.INSTANCE.getContainer(e);
        }
        return e;
    }

    protected final DDLGenerator getDDLGenerator() {
        EObject x = (EObject)this.changeSummary.getDataGraph().getRootObject();
        Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement(x);
        DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
        return def.getDDLGenerator();
    }

    protected final Object getOldValue(EStructuralFeature feature, EDataObject changed) {
        Iterator it = this.changeSummary.getOldValues((DataObject)changed).iterator();
        while (it.hasNext()) {
            ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)it.next();
            EProperty p = (EProperty)changeSetting.getProperty();
            if (p.getEStructuralFeature() != feature) continue;
            return changeSetting.getValue();
        }
        return changed.eGet(feature);
    }

    protected final boolean ancestorModified(Map changeMap, EObject e) {
        Iterator it = ContainmentServiceImpl.INSTANCE.getAllContainers(e).iterator();
        while (it.hasNext()) {
            Object c = it.next();
            if (!changeMap.containsKey(c)) continue;
            changeMap.get(c);
            int flag = (Integer)changeMap.get(c);
            if ((flag & 0xF) == 0) continue;
            return true;
        }
        return false;
    }

    private Map buildChangeMap(IProgressMonitor monitor) {
        HashMap<EDataObject, Integer> changeMap = new HashMap<EDataObject, Integer>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            EDataObject element;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (element = (EDataObject)this.getDisplayableElement((EObject)(changed = (EDataObject)changedObject))) == null) continue;
            int flag = 0;
            if (changeMap.containsKey(element)) {
                flag = (Integer)changeMap.get(element);
            }
            if (flag == 2 || flag == 1) continue;
            if (this.changeSummary.isCreated((DataObject)element)) {
                if (this.changeSummary.isDeleted((DataObject)element)) continue;
                flag = 1;
            } else if (this.changeSummary.isDeleted((DataObject)element)) {
                flag = 2;
            } else {
                List oldValues;
                if (this.changeSummary.isCreated((DataObject)changed) || this.changeSummary.isDeleted((DataObject)changed) || (oldValues = this.changeSummary.getOldValues((DataObject)changed)) == null) continue;
                Iterator vi = oldValues.iterator();
                while (vi.hasNext()) {
                    ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                    EProperty p = (EProperty)changeSetting.getProperty();
                    EStructuralFeature f = p.getEStructuralFeature();
                    if (!changeSetting.isSet() && !changed.eIsSet(f)) continue;
                    Object currentValue = changed.eGet(f);
                    Object previousValue = changeSetting.getValue();
                    if (previousValue == null) {
                        previousValue = "";
                    }
                    if (currentValue == null) {
                        if (this.underContainer(f, changed, previousValue)) {
                            flag = 2;
                            changeMap.put(changed, new Integer(flag));
                            flag = 0;
                            break;
                        }
                        currentValue = "";
                    }
                    if (f == SQLSchemaPackage.eINSTANCE.getSQLObject_Privileges()) {
                        this.buildPrivilegeGrantChangeMapEntries(changeMap, currentValue, previousValue);
                        continue;
                    }
                    if (f == SQLAccessControlPackage.eINSTANCE.getAuthorizationIdentifier_ReceivedPrivilege()) {
                        this.buildPrivilegeGrantChangeMapEntries(changeMap, currentValue, previousValue);
                        continue;
                    }
                    if (f.getEContainingClass() == SQLAccessControlPackage.eINSTANCE.getPrivilege()) {
                        this.buildPrivilegeChangeMapEntries(changeMap, (Privilege)changedObject, f, currentValue, previousValue);
                        continue;
                    }
                    if (f == SQLAccessControlPackage.eINSTANCE.getAuthorizationIdentifier_ReceivedRoleAuthorization()) {
                        this.buildRoleAuthGrantChangeMapEntries(changeMap, currentValue, previousValue);
                        continue;
                    }
                    if (f.getEContainingClass() == SQLAccessControlPackage.eINSTANCE.getRoleAuthorization()) {
                        this.buildRoleAuthChangeMapEntries(changeMap, (RoleAuthorization)changedObject, f, currentValue, previousValue);
                        continue;
                    }
                    if (currentValue.equals(previousValue)) continue;
                    flag |= this.getChangeFlag((EObject)element, (EObject)changed, f, changeSetting);
                }
            }
            if (flag == 0) continue;
            changeMap.put(element, new Integer(flag));
        }
        return changeMap;
    }

    /*
     * Unable to fully structure code
     */
    private void buildPrivilegeGrantChangeMapEntries(Map changeMap, Object currentValue, Object previousValue) {
        block7: {
            block6: {
                if (!(currentValue instanceof EList)) break block6;
                cVIter = ((EList)currentValue).iterator();
                if (!(previousValue instanceof EList)) ** GOTO lbl21
                while (cVIter.hasNext()) {
                    cPrivilege = (Privilege)cVIter.next();
                    pVIter = ((EList)previousValue).iterator();
                    match = false;
                    while (pVIter.hasNext()) {
                        pPrivilege = (Privilege)pVIter.next();
                        if (cPrivilege != pPrivilege) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    changeMap.put(cPrivilege, new Integer(1));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    privilege = (Privilege)cVIter.next();
                    changeMap.put(privilege, new Integer(1));
lbl21:
                    // 2 sources

                    ** while (cVIter.hasNext())
                }
            }
            if (!(previousValue instanceof EList)) break block7;
            pVIter = ((EList)previousValue).iterator();
            if (!(currentValue instanceof EList)) ** GOTO lbl43
            while (pVIter.hasNext()) {
                pPrivilege = (Privilege)pVIter.next();
                cVIter = ((EList)currentValue).iterator();
                match = false;
                while (cVIter.hasNext()) {
                    cPrivilege = (Privilege)cVIter.next();
                    if (cPrivilege != pPrivilege) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                changeMap.put(pPrivilege, new Integer(2));
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                privilege = (Privilege)pVIter.next();
                changeMap.put(privilege, new Integer(2));
lbl43:
                // 2 sources

                ** while (pVIter.hasNext())
            }
        }
    }

    private void buildPrivilegeChangeMapEntries(Map changeMap, Privilege changedObject, EStructuralFeature f, Object currentValue, Object previousValue) {
        if (f.getName().equals("grantable")) {
            changeMap.put(changedObject, new Integer(3));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildRoleAuthGrantChangeMapEntries(Map changeMap, Object currentValue, Object previousValue) {
        block7: {
            block6: {
                if (!(currentValue instanceof EList)) break block6;
                cVIter = ((EList)currentValue).iterator();
                if (!(previousValue instanceof EList)) ** GOTO lbl21
                while (cVIter.hasNext()) {
                    cRoleAuth = (RoleAuthorization)cVIter.next();
                    pVIter = ((EList)previousValue).iterator();
                    match = false;
                    while (pVIter.hasNext()) {
                        pRoleAuth = (RoleAuthorization)pVIter.next();
                        if (cRoleAuth != pRoleAuth) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    changeMap.put(cRoleAuth, new Integer(1));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    roleAuth = (RoleAuthorization)cVIter.next();
                    changeMap.put(roleAuth, new Integer(1));
lbl21:
                    // 2 sources

                    ** while (cVIter.hasNext())
                }
            }
            if (!(previousValue instanceof EList)) break block7;
            pVIter = ((EList)previousValue).iterator();
            if (!(currentValue instanceof EList)) ** GOTO lbl43
            while (pVIter.hasNext()) {
                pRoleAuth = (RoleAuthorization)pVIter.next();
                cVIter = ((EList)currentValue).iterator();
                match = false;
                while (cVIter.hasNext()) {
                    cRoleAuth = (RoleAuthorization)cVIter.next();
                    if (cRoleAuth != pRoleAuth) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                changeMap.put(pRoleAuth, new Integer(2));
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                roleAuth = (RoleAuthorization)pVIter.next();
                changeMap.put(roleAuth, new Integer(2));
lbl43:
                // 2 sources

                ** while (pVIter.hasNext())
            }
        }
    }

    private void buildRoleAuthChangeMapEntries(Map changeMap, RoleAuthorization changedObject, EStructuralFeature f, Object currentValue, Object previousValue) {
        if (f.getName().equals("grantable")) {
            changeMap.put(changedObject, new Integer(3));
        }
    }

    private boolean underContainer(EStructuralFeature f, Object obj, Object container) {
        if (!(obj instanceof EObject) || !(container instanceof EObject)) {
            return false;
        }
        EStructuralFeature feature = ContainmentServiceImpl.INSTANCE.getContainmentFeature((EObject)obj);
        if (feature != null) {
            return feature.getEContainingClass().isInstance(container);
        }
        return false;
    }

    private void executeChangeRecords(Collection changeRecords) {
        Iterator it = changeRecords.iterator();
        while (it.hasNext()) {
            ChangeRecord r = (ChangeRecord)it.next();
            boolean deliver = r.element.eDeliver();
            r.element.eSetDeliver(false);
            if (r.isSet) {
                if (r.feature.isMany()) {
                    Collection c = (Collection)r.element.eGet(r.feature);
                    c.clear();
                    c.addAll((Collection)r.value);
                } else {
                    r.element.eSet(r.feature, r.value);
                }
            } else {
                r.element.eUnset(r.feature);
            }
            r.element.eSetDeliver(deliver);
        }
    }

    private static class ChangeRecord {
        public EObject element;
        public EStructuralFeature feature;
        public Object value;
        public boolean isSet;

        private ChangeRecord() {
        }
    }
}

