/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.IEditModelHandler;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;

public class ArtifactEdit
implements IEditModelHandler,
IAdaptable {
    public static final Class ADAPTER_TYPE;
    private final ArtifactEditModel artifactEditModel;
    private boolean isReadOnly;
    private boolean isArtifactEditModelSelfManaged;
    private boolean isBinary;
    private BinaryComponentHelper binaryComponentHelper;
    private final IProject project;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.componentcore.ArtifactEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz;
    }

    protected ArtifactEdit() {
        this.artifactEditModel = null;
        this.project = null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent aModule) {
        if (aModule.isBinary()) {
            return new ArtifactEdit(aModule);
        }
        if (ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, true);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent aModule) {
        if (!aModule.isBinary() && ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, false);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IProject aProject) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aProject, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static ArtifactEdit getArtifactEditForWrite(IProject aProject) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aProject, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static boolean isValidEditableModule(IVirtualComponent aModule) {
        if (aModule == null) {
            return false;
        }
        if (ModuleURIUtil.fullyQualifyURI(aModule.getProject()) == null) {
            return false;
        }
        IProject project = aModule.getProject();
        return project != null && project.isAccessible();
    }

    public ArtifactEdit(ArtifactEditModel anArtifactEditModel) {
        this.artifactEditModel = anArtifactEditModel;
        this.isReadOnly = this.artifactEditModel.isReadOnly();
        this.isArtifactEditModelSelfManaged = false;
        this.project = anArtifactEditModel.getProject();
    }

    protected ArtifactEdit(IVirtualComponent aBinaryModule) {
        if (!aBinaryModule.isBinary()) {
            throw new RuntimeException("This constructor is only for binary components.");
        }
        this.binaryComponentHelper = this.initBinaryComponentHelper(aBinaryModule);
        this.artifactEditModel = null;
        this.isReadOnly = true;
        this.isBinary = true;
        this.isArtifactEditModelSelfManaged = true;
        this.project = null;
    }

    protected BinaryComponentHelper initBinaryComponentHelper(IVirtualComponent binaryModule) {
        return null;
    }

    protected ArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        this.artifactEditModel = toAccessAsReadOnly ? aNature.getArtifactEditModelForRead(ModuleURIUtil.fullyQualifyURI(aModule.getProject()), this) : aNature.getArtifactEditModelForWrite(ModuleURIUtil.fullyQualifyURI(aModule.getProject()), this);
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
        this.project = aNature.getProject();
    }

    public ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        this(aProject, toAccessAsReadOnly, false, null);
    }

    protected ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate, String projectType) throws IllegalArgumentException {
        this(aProject, toAccessAsReadOnly, forCreate, projectType, null);
    }

    protected ArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate, String projectType, Map editModelParams) throws IllegalArgumentException {
        if (aProject == null || !aProject.isAccessible()) {
            throw new IllegalArgumentException("Invalid project: " + aProject);
        }
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(aProject);
        if (nature == null) {
            throw new IllegalArgumentException("Project does not have ModuleCoreNature: " + aProject);
        }
        IVirtualComponent component = ComponentCore.createComponent(aProject);
        if (component == null) {
            throw new IllegalArgumentException("Invalid component handle: " + aProject);
        }
        if (!forCreate && !ArtifactEdit.isValidEditableModule(component)) {
            throw new IllegalArgumentException("Invalid component handle: " + aProject);
        }
        URI componentURI = ModuleURIUtil.fullyQualifyURI(aProject);
        this.artifactEditModel = toAccessAsReadOnly ? nature.getArtifactEditModelForRead(componentURI, this, projectType, editModelParams) : nature.getArtifactEditModelForWrite(componentURI, this, projectType, editModelParams);
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
        this.project = aProject;
    }

    public void save(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.validateEdit().isOK()) {
            this.artifactEditModel.save(aMonitor, this);
        }
    }

    public void saveIfNecessary(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.validateEdit().isOK()) {
            this.artifactEditModel.saveIfNecessary(aMonitor, this);
        }
    }

    protected IStatus validateEdit() {
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        return validator.validateState((EditModel)this.getArtifactEditModel());
    }

    public void saveIfNecessaryWithPrompt(IProgressMonitor monitor, IOperationHandler operationHandler, boolean wasDirty) {
        if (this.shouldSave(operationHandler, wasDirty)) {
            this.saveIfNecessary(monitor);
        } else {
            this.handleSaveIfNecessaryDidNotSave(monitor);
        }
    }

    private void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
    }

    private boolean shouldSave(IOperationHandler operationHandler, boolean wasDirty) {
        return !wasDirty ? this.shouldSave() : this.shouldSave(operationHandler);
    }

    private boolean promptToSave(IOperationHandler operationHandler) {
        if (operationHandler == null) {
            return false;
        }
        return operationHandler.canContinue(EMFWorkbenchResourceHandler.getString((String)"The_following_resources_ne_UI_"), this.getArtifactEditModel().getResourceURIs(true));
    }

    private boolean shouldSave(IOperationHandler operationHandler) {
        return this.shouldSave() || this.promptToSave(operationHandler);
    }

    private boolean shouldSave() {
        return !this.isReadOnly() && this.isArtifactEditModelSelfManaged;
    }

    public void dispose() {
        if (this.isBinary()) {
            this.binaryComponentHelper.releaseAccess(this);
        } else if (this.isArtifactEditModelSelfManaged && this.artifactEditModel != null) {
            this.artifactEditModel.releaseAccess(this);
        }
    }

    public EObject getContentModelRoot() {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getPrimaryRootObject();
        }
        if (this.artifactEditModel != null) {
            return this.artifactEditModel.getPrimaryRootObject();
        }
        return null;
    }

    public void addListener(EditModelListener listener) {
        if (!this.isBinary() && this.artifactEditModel != null && listener != null) {
            this.artifactEditModel.addListener(listener);
        }
    }

    public void removeListener(EditModelListener listener) {
        if (!this.isBinary() && this.artifactEditModel != null && !this.artifactEditModel.isDisposed()) {
            this.artifactEditModel.removeListener(listener);
        }
    }

    public boolean hasEditModel(EditModel editModel) {
        if (this.isBinary()) {
            return false;
        }
        return this.artifactEditModel == editModel;
    }

    public IProject getProject() {
        if (this.isBinary()) {
            return null;
        }
        return this.project;
    }

    public IVirtualComponent getComponent() {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getComponent();
        }
        return this.getArtifactEditModel().getVirtualComponent();
    }

    protected ArtifactEditModel getArtifactEditModel() {
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        return this.artifactEditModel;
    }

    protected BinaryComponentHelper getBinaryComponentHelper() {
        return this.binaryComponentHelper;
    }

    public CommandStack getCommandStack() {
        if (this.isBinary()) {
            return new BasicCommandStack();
        }
        return this.artifactEditModel.getCommandStack();
    }

    public void deleteResource(Resource aResource) {
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        this.artifactEditModel.deleteResource(aResource);
    }

    public boolean isDirty() {
        if (this.isBinary()) {
            return false;
        }
        return this.artifactEditModel.isDirty();
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException("Attempt to modify an ArtifactEdit instance facade that was loaded as read-only.");
    }

    protected void throwAttemptedBinaryEditModelAccess() {
        throw new IllegalStateException("Attempt to modify an ArtifactEdit instance facade that was loaded as binary.");
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void forceLoadKnownResources() {
        if (!this.isBinary()) {
            List uris = this.getArtifactEditModel().getKnownResourceUris();
            URI uri = null;
            int i = 0;
            while (i < uris.size()) {
                uri = (URI)uris.get(i);
                this.getArtifactEditModel().getResource(uri);
                ++i;
            }
        }
    }

    public Resource getResource(URI aUri) {
        if (this.isBinary()) {
            return this.binaryComponentHelper.getResource(aUri);
        }
        return this.getArtifactEditModel().getResource(aUri);
    }

    public Object getAdapter(Class adapterType) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.common.componentcore.internal.ArtifactEditModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapterType == clazz) {
            return this.getArtifactEditModel();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void commandStackChanged(EventObject event) {
        this.getArtifactEditModel().commandStackChanged(event);
    }
}

