/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.osgi.framework.Bundle;

public class ComponentResolver
implements URIResolverExtension {
    private static boolean _DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.wst.common.modulecore/ComponentResolver"));
    private static final String FILE_PROTOCOL = "file:///";
    private static final String FILE_PROTOCOL2 = "file://";
    private static final String ROOT_PATH_STRING = Path.ROOT.toString();
    private static final String HTTP_PROTOCOL = "http:";

    private IFile recalculateFile(String uri) {
        IFile file = null;
        String location = null;
        long time0 = -1L;
        if (_DEBUG) {
            time0 = System.currentTimeMillis();
        }
        if (uri.startsWith(HTTP_PROTOCOL)) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URI.create(uri));
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].isAccessible()) {
                    file = files[i];
                }
                ++i;
            }
            if (_DEBUG) {
                System.out.println("\"" + uri + "\" findFilesForLocationURI:" + (System.currentTimeMillis() - time0));
                time0 = System.currentTimeMillis();
            }
        } else {
            location = uri.startsWith(FILE_PROTOCOL) ? uri.substring(FILE_PROTOCOL.length()) : (uri.startsWith(FILE_PROTOCOL2) ? uri.substring(FILE_PROTOCOL2.length()) : uri);
            Path path = new Path(location);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].isAccessible()) {
                    file = files[i];
                }
                ++i;
            }
        }
        if (_DEBUG) {
            System.out.println("\"" + location + "\" findFilesForLocation:" + (System.currentTimeMillis() - time0));
        }
        return file;
    }

    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        IVirtualResource[] virtualResources;
        String resolvedPath;
        boolean prependFilePrefix2;
        boolean prependFilePrefix;
        block26: {
            Path systemPath;
            if (_DEBUG) {
                System.out.print("ComponentResolver: resolve \"[{" + publicId + "}{" + systemId + "}]\" from \"" + baseLocation + "\"");
            }
            if (systemId == null || systemId.length() == 0) {
                if (_DEBUG) {
                    System.out.println(" (no system reference)");
                }
                return null;
            }
            if (file == null) {
                if (baseLocation == null || baseLocation.length() == 0 || baseLocation.startsWith("wbit:")) {
                    if (_DEBUG) {
                        System.out.println(" (no base location or file given)");
                    }
                    return null;
                }
                file = this.recalculateFile(baseLocation);
            }
            if (file == null) {
                if (_DEBUG) {
                    System.out.println(" (not a workspace file)");
                }
                return null;
            }
            try {
                URL testURL = new URL(systemId);
                if (testURL != null) {
                    if (_DEBUG) {
                        System.out.println(" (reference is already a URL)");
                    }
                    return null;
                }
            }
            catch (MalformedURLException malformedURLException) {}
            try {
                URI uri = new URI(systemId);
                if (uri.getScheme() == null && uri.getHost() != null) {
                    return null;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            if ((systemPath = new Path(systemId)).toFile().exists()) {
                if (_DEBUG) {
                    System.out.println(" (reference is a system file)");
                }
                return null;
            }
            prependFilePrefix = baseLocation.startsWith(FILE_PROTOCOL) && baseLocation.length() > 7;
            prependFilePrefix2 = baseLocation.startsWith(FILE_PROTOCOL2) && baseLocation.length() > 8;
            resolvedPath = null;
            virtualResources = null;
            try {
                virtualResources = ComponentCore.createResources((IResource)file);
            }
            catch (Exception e) {
                Status statusObj = new Status(4, "org.eclipse.wst.common.modulecore", 4, "Exception calling ComponentCore.createResources()", (Throwable)e);
                Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.modulecore");
                if (bundle == null) break block26;
                Platform.getLog((Bundle)bundle).log((IStatus)statusObj);
            }
        }
        if (virtualResources != null) {
            int i = 0;
            while (i < virtualResources.length && resolvedPath == null) {
                Path resolvedRuntimePath = null;
                resolvedRuntimePath = systemId.startsWith(ROOT_PATH_STRING) ? new Path(systemId) : new Path(virtualResources[i].getRuntimePath().removeLastSegments(1).append(systemId).toString());
                IVirtualFile virtualFile = ComponentCore.createFile(file.getProject(), (IPath)resolvedRuntimePath);
                IFile resolvedFile = null;
                if (virtualFile.getWorkspaceRelativePath().segmentCount() > 1) {
                    resolvedFile = virtualFile.getUnderlyingFile();
                }
                if (resolvedFile != null && resolvedFile.getLocation() != null) {
                    resolvedPath = prependFilePrefix ? FILE_PROTOCOL + resolvedFile.getLocation().toString() : (prependFilePrefix2 ? FILE_PROTOCOL2 + resolvedFile.getLocation().toString() : resolvedFile.getLocation().toString());
                }
                ++i;
            }
        } else if (_DEBUG) {
            System.out.println(" (not in flexible project)");
        }
        if (_DEBUG) {
            System.out.println(" -> \"" + resolvedPath + "\"");
        }
        return resolvedPath;
    }
}

