/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPluginIcons;
import org.eclipse.jst.j2ee.internal.wizard.EARImportListContentProvider;
import org.eclipse.jst.j2ee.internal.wizard.TableObjects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EARComponentProjectsPage
extends DataModelWizardPage {
    private CheckboxTableViewer earFileListViewer;
    public static final String INCLUDE_COLUMN = J2EEUIMessages.getResourceString("EARImportProjectsPage_UI_0");
    public static final String FILE_COLUMN = J2EEUIMessages.getResourceString("EARImportProjectsPage_UI_1");
    public static final String PROJECT_COLUMN = J2EEUIMessages.getResourceString("EARImportProjectsPage_UI_2");

    public EARComponentProjectsPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("52"));
        this.setDescription(J2EEUIMessages.getResourceString("51"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EAR_IMPORT_EAR_WIZARD_PAGE3");
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createListGroup(composite);
        this.createButtonsGroup(composite);
        return composite;
    }

    protected void setColumnEditors() {
        Table t = this.earFileListViewer.getTable();
        CellEditor[] columnEditors = new CellEditor[t.getColumnCount()];
        columnEditors[1] = new TextCellEditor((Composite)t);
        this.earFileListViewer.setCellEditors(columnEditors);
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1808));
        Button selectNotInWorkspace = new Button(buttonGroup, 8);
        selectNotInWorkspace.setText(J2EEUIMessages.getResourceString("EARImportProjectsPage_UI_3"));
        GridData gd = new GridData(272);
        gd.widthHint = 140;
        selectNotInWorkspace.setLayoutData((Object)gd);
        selectNotInWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)EARComponentProjectsPage.this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
                List selectedList = (List)EARComponentProjectsPage.this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
                ArrayList<IDataModel> newList = new ArrayList<IDataModel>();
                newList.addAll(selectedList);
                IDataModel importDM = null;
                int i = 0;
                while (i < list.size()) {
                    importDM = (IDataModel)list.get(i);
                    if (!newList.contains(importDM) && !((IVirtualComponent)importDM.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT")).exists()) {
                        newList.add(importDM);
                    }
                    ++i;
                }
                EARComponentProjectsPage.this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
            }
        });
        Button selectAllButton = new Button(buttonGroup, 8);
        selectAllButton.setText(J2EEUIMessages.getResourceString("47"));
        gd = new GridData(272);
        gd.widthHint = 140;
        selectAllButton.setLayoutData((Object)gd);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)EARComponentProjectsPage.this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
                ArrayList newList = new ArrayList();
                newList.addAll(list);
                EARComponentProjectsPage.this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
            }
        });
        Button deselectAllButton = new Button(buttonGroup, 8);
        deselectAllButton.setText(J2EEUIMessages.getResourceString("48"));
        gd = new GridData(272);
        gd.widthHint = 140;
        deselectAllButton.setLayoutData((Object)gd);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList newList = new ArrayList();
                EARComponentProjectsPage.this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
            }
        });
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST") && this.earFileListViewer != null) {
            this.updateGUICheckSelection();
        }
        super.propertyChanged(event);
    }

    public void setFileListViewerInput() {
        TableObjects files = new TableObjects();
        Iterator iterator = ((List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST")).iterator();
        while (iterator.hasNext()) {
            files.tableObjectsList.add(iterator.next());
        }
        this.earFileListViewer.setInput((Object)files);
        this.updateGUICheckSelection();
    }

    private void updateGUICheckSelection() {
        List selectedList = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        List projectList = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
        Object currentElement = null;
        int i = 0;
        while (i < projectList.size()) {
            currentElement = projectList.get(i);
            this.earFileListViewer.setChecked(currentElement, selectedList.contains(currentElement));
            ++i;
        }
    }

    protected void enter() {
        super.enter();
        this.setFileListViewerInput();
        this.validatePage();
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        listGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        listGroup.setLayoutData((Object)gd);
        this.earFileListViewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)68352);
        EARImportListContentProvider provider = new EARImportListContentProvider();
        this.earFileListViewer.setContentProvider((IContentProvider)provider);
        this.earFileListViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.earFileListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object matchingModel = null;
                if (matchingModel != null) {
                    EARComponentProjectsPage.this.earFileListViewer.setChecked(matchingModel, event.getChecked());
                }
                ArrayList result = new ArrayList();
                result.addAll(Arrays.asList(EARComponentProjectsPage.this.earFileListViewer.getCheckedElements()));
                EARComponentProjectsPage.this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", result);
            }
        });
        Table earFileListTable = (Table)this.earFileListViewer.getControl();
        earFileListTable.setHeaderVisible(true);
        earFileListTable.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        earFileListTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        gd.widthHint = 400;
        earFileListTable.setLayoutData((Object)gd);
        TableColumn fileNameColumns = new TableColumn(earFileListTable, 0);
        fileNameColumns.setText(J2EEUIMessages.getResourceString("58"));
        fileNameColumns.setResizable(true);
        TableColumn importNameColumn = new TableColumn(earFileListTable, 0);
        importNameColumn.setText(J2EEUIMessages.getResourceString("59"));
        importNameColumn.setResizable(true);
        String[] columnProperties = new String[]{FILE_COLUMN, PROJECT_COLUMN};
        this.earFileListViewer.setColumnProperties(columnProperties);
        this.setColumnEditors();
        this.earFileListViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return PROJECT_COLUMN.equals(property);
            }

            public Object getValue(Object element, String property) {
                TableItem[] items = EARComponentProjectsPage.this.earFileListViewer.getTable().getSelection();
                TableItem item = items[0];
                return item.getText(1);
            }

            public void modify(Object element, String property, Object value) {
                TableItem elementHolder = (TableItem)element;
                if (property.equals(PROJECT_COLUMN)) {
                    elementHolder.setText(1, (String)value);
                    ((IDataModel)elementHolder.getData()).setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", value);
                }
            }
        });
    }

    protected void restoreWidgetValues() {
    }

    public void storeDefaultSettings() {
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", "EARImportDataModel.NESTED_PROJECTS_VALIDATION"};
    }
}

