/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDelegatesRegistry {
    private static ValidatorDelegatesRegistry _instance;
    private Map<String, Map<String, ValidatorDelegateDescriptor>> _delegatesByTarget = new HashMap<String, Map<String, ValidatorDelegateDescriptor>>();

    public static ValidatorDelegatesRegistry getInstance() {
        if (_instance == null) {
            _instance = new ValidatorDelegatesRegistry();
            ValidatorDelegatesRegistryReader reader = new ValidatorDelegatesRegistryReader(_instance);
            reader.readRegistry();
        }
        return _instance;
    }

    void add(ValidatorDelegateDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        String targetID = descriptor.getTargetID();
        Map<String, ValidatorDelegateDescriptor> delegates = this._delegatesByTarget.get(targetID);
        if (delegates == null) {
            delegates = new HashMap<String, ValidatorDelegateDescriptor>();
            this._delegatesByTarget.put(targetID, delegates);
        }
        delegates.put(descriptor.getId(), descriptor);
    }

    public String getDefaultDelegate(String targetID) {
        Map<String, ValidatorDelegateDescriptor> delegates = this.getDelegateDescriptors(targetID);
        if (delegates == null) {
            return null;
        }
        Iterator<ValidatorDelegateDescriptor> delegatesIterator = delegates.values().iterator();
        if (!delegatesIterator.hasNext()) {
            return null;
        }
        return delegatesIterator.next().getId();
    }

    public IValidator getDelegate(String targetID, String delegateID) throws ValidationException {
        ValidatorDelegateDescriptor descriptor = this.getDescriptor(targetID, delegateID);
        if (descriptor == null) {
            return null;
        }
        IValidator delegate = descriptor.getValidator();
        return delegate;
    }

    public Map<String, ValidatorDelegateDescriptor> getDelegateDescriptors(String targetID) {
        return this._delegatesByTarget.get(targetID);
    }

    public ValidatorDelegateDescriptor getDescriptor(String targetID, String delegateID) {
        Map<String, ValidatorDelegateDescriptor> delegates = this._delegatesByTarget.get(targetID);
        if (delegates == null || delegateID == null) {
            return null;
        }
        ValidatorDelegateDescriptor descriptor = delegates.get(delegateID);
        return descriptor;
    }

    public boolean hasDelegates(String targetID) {
        Map<String, ValidatorDelegateDescriptor> delegatesByID = this._delegatesByTarget.get(targetID);
        boolean hasDelegates = delegatesByID != null && !delegatesByID.isEmpty();
        return hasDelegates;
    }
}

