/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Alerts;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.preference.GEMPreferences;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EditorPlugin
extends AbstractUIPlugin {
    private static EditorPlugin plugin;
    private Logger log;
    private ResourceBundle resourceBundle;
    private static Alerts alerts;
    private URL pluginBase;

    public EditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.jst.jsf.facesconfig.ui.EditorPluginResources");
            alerts = new Alerts((AbstractUIPlugin)this, this.resourceBundle);
            this.pluginBase = this.getBundle().getEntry("/");
            this.log = new Logger(this.getBundle(), this.resourceBundle);
        }
        catch (Exception ee) {
            if (this.log != null) {
                this.log.error("log.msg", "Problems starting plug-in Faces Config Editor.", (Throwable)ee);
            }
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Faces Config Editor", (Throwable)ee));
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static EditorPlugin getDefault() {
        return plugin;
    }

    public static Alerts getAlerts() {
        return alerts;
    }

    public static Logger getLogger(Class theClass) {
        return EditorPlugin.getDefault().getRootLogger();
    }

    public Logger getRootLogger() {
        return this.log;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (EditorPlugin.getDefault().getWorkbench() == null) {
            return null;
        }
        return EditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveShell() {
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        return shell;
    }

    public Image getImage(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        Image image = images.get(name);
        if (image == null) {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(this.pluginBase, "icons/" + name));
                images.put(name, id);
                image = images.get(name);
            }
            catch (MalformedURLException ee) {
                this.log.error("log.msg", "log.EditorPlugin.image.error", name, (Throwable)ee);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        if (path == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        ImageDescriptor id = images.getDescriptor(path);
        if (id == null) {
            try {
                id = ImageDescriptor.createFromURL((URL)new URL(this.pluginBase, "icons/" + path));
                images.put(path, id);
            }
            catch (MalformedURLException ee) {
                this.log.error("log.msg", "log.EditorPlugin.image.error", path, (Throwable)ee);
            }
        }
        return id;
    }

    public static String getPluginId() {
        return EditorPlugin.getDefault().getBundle().getSymbolicName();
    }

    protected void initializeDefaultPluginPreferences() {
        new GEMPreferences();
    }
}

