/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.command.StartServerCommand;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class AddModuleDependenciesCommand
extends AbstractDataModelOperation {
    private TestInfo testInfo;
    private IProject sampleIProject;
    private IProject clientIProject;
    private IProject sampleEARIProject;
    private String sampleEARProject;
    public static final String DEFAULT_SAMPLE_EAR_PROJECT_EXT = "EAR";

    public AddModuleDependenciesCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        ValidationUtils vu;
        boolean serverNeedsEAR;
        IEnvironment env = this.getEnvironment();
        this.sampleIProject = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
        boolean createdSampleProject = false;
        if (!this.sampleIProject.exists()) {
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.testInfo.getGenerationProject());
            command.setTemplateId("template.jst.web");
            command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
            command.setServerFactoryId(this.testInfo.getClientServerTypeID());
            command.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            IStatus status2 = command.execute(monitor, adaptable);
            if (status2.getSeverity() == 4) {
                env.getStatusHandler().reportError(status2);
                return status2;
            }
            createdSampleProject = true;
        }
        if (serverNeedsEAR = (vu = new ValidationUtils()).serverNeedsEAR(this.testInfo.getClientServerTypeID())) {
            this.sampleEARProject = this.testInfo.getClientEARProject() == null || this.testInfo.getClientEARProject().length() == 0 ? String.valueOf(this.testInfo.getGenerationProject()) + DEFAULT_SAMPLE_EAR_PROJECT_EXT : this.testInfo.getClientEARProject();
            this.sampleEARIProject = ProjectUtilities.getProject((String)this.sampleEARProject);
            if (this.sampleEARIProject == null || !this.sampleEARIProject.exists()) {
                CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
                command.setProjectName(this.sampleEARProject);
                command.setTemplateId("template.jst.ear");
                command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
                command.setServerFactoryId(this.testInfo.getClientServerTypeID());
                command.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
                status = command.execute(monitor, adaptable);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
            }
        }
        if (serverNeedsEAR) {
            AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
            associateCommand.setProject(this.testInfo.getGenerationProject());
            associateCommand.setEARProject(this.sampleEARProject);
            associateCommand.setEar(this.sampleEARProject);
            associateCommand.setEnvironment(env);
            status = associateCommand.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        if (serverNeedsEAR && this.testInfo.getClientExistingServer() != null) {
            AddModuleToServerCommand modToServer = new AddModuleToServerCommand();
            modToServer.setModule(this.sampleEARProject);
            modToServer.setProject(this.sampleEARProject);
            modToServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            modToServer.setEnvironment(env);
            status = modToServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        } else if (this.testInfo.getClientExistingServer() != null) {
            AddModuleToServerCommand addToServer = new AddModuleToServerCommand();
            addToServer.setModule(this.testInfo.getGenerationProject());
            addToServer.setProject(this.testInfo.getGenerationProject());
            addToServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            addToServer.setEnvironment(env);
            status = addToServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        if (createdSampleProject) {
            StartServerCommand startServer = new StartServerCommand(true);
            startServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            startServer.setEnvironment(env);
            status = startServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        this.clientIProject = ProjectUtilities.getProject((String)this.testInfo.getClientProject());
        if (this.clientIProject != null && !J2EEUtils.isWebComponent((IProject)this.clientIProject)) {
            IStatus errorStatus;
            String errorMessage;
            if (J2EEUtils.isJavaComponent((IProject)this.clientIProject)) {
                J2EEUtils.addJavaProjectAsUtilityJar((IProject)this.clientIProject, (IProject)this.sampleEARIProject, (IProgressMonitor)monitor);
                J2EEUtils.addJavaProjectAsUtilityJar((IProject)this.clientIProject, (IProject)this.sampleIProject, (IProgressMonitor)monitor);
            }
            try {
                String uri = String.valueOf(this.clientIProject.getName()) + ".jar";
                J2EEUtils.addJAROrModuleDependency((IProject)this.sampleIProject, (String)uri);
                IClasspathEntry[] classPath = JavaCore.create((IProject)this.clientIProject).getRawClasspath();
                int i = 0;
                while (i < classPath.length) {
                    IClasspathEntry classpathEntry = classPath[i];
                    if (classpathEntry.getEntryKind() == 1) {
                        UpdateClasspathAttributeUtil.addDependencyAttribute((IProgressMonitor)monitor, (String)this.clientIProject.getName(), (IClasspathEntry)classpathEntry);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{this.sampleIProject.getName(), this.clientIProject.getName()});
                errorStatus = StatusUtils.errorStatus((String)errorMessage);
                env.getStatusHandler().reportError(errorStatus);
            }
            catch (IOException iOException) {
                errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{this.sampleIProject.getName(), this.clientIProject.getName()});
                errorStatus = StatusUtils.errorStatus((String)errorMessage);
                env.getStatusHandler().reportError(errorStatus);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }
}

