/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistryReader;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class DeployerRegistry {
    private static DeployerRegistry INSTANCE;
    private HashMap deployModuleExtensions = new HashMap();
    private HashMap facetExceptions = new HashMap();

    public void register(IConfigurationElement deployer, List serverTargets, List natures, List facetExclusions) {
        for (String natureID : natures) {
            for (String runtimeID : serverTargets) {
                HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
                this.getTargetDeployers(targetDeployers, runtimeID).add(deployer);
            }
        }
        List facets = this.getFacetExceptions(deployer);
        for (String facetID : facetExclusions) {
            if (facets.contains(facetID)) continue;
            facets.add(facetID);
        }
    }

    public void register(IConfigurationElement deployer, List serverTargets, List natures) {
        this.register(deployer, serverTargets, natures, new ArrayList());
    }

    private List getDeployers(String natureID, String serverTarget) {
        HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
        return this.getTargetDeployers(targetDeployers, serverTarget);
    }

    public static DeployerRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new DeployerRegistry();
            DeployerRegistry.readRegistry();
        }
        return INSTANCE;
    }

    private static void readRegistry() {
        DeployerRegistryReader reader = new DeployerRegistryReader();
        reader.readRegistry();
    }

    public static List getSelectedModules(Object[] mySelections) {
        ArrayList<IVirtualComponent> modules = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < mySelections.length) {
            Object object = mySelections[i];
            if (object instanceof EObject) {
                object = ProjectUtilities.getProject((Object)object);
            }
            if (object instanceof IProject) {
                EObject root;
                IVirtualComponent component = ComponentCore.createComponent((IProject)((IProject)object));
                IModelProvider modelProvider = null;
                modelProvider = ModelProviderManager.getModelProvider(component.getProject());
                if (modelProvider != null && (root = (EObject)modelProvider.getModelObject()) != null && !modules.contains(component)) {
                    if (JavaEEProjectUtilities.isEARProject(component.getProject())) {
                        modules.add(0, component);
                    } else {
                        modules.add(component);
                    }
                }
            }
            ++i;
        }
        return modules;
    }

    private List getTargetDeployers(HashMap targetDeployers, String serverTarget) {
        if (targetDeployers.get(serverTarget) == null) {
            targetDeployers.put(serverTarget, new ArrayList());
        }
        return (List)targetDeployers.get(serverTarget);
    }

    private HashMap getDeployModuleExtensions(String natureID) {
        if (this.getDeployModuleExtensions().get(natureID) == null) {
            this.getDeployModuleExtensions().put(natureID, new HashMap());
        }
        return (HashMap)this.getDeployModuleExtensions().get(natureID);
    }

    public HashMap getDeployModuleExtensions() {
        return this.deployModuleExtensions;
    }

    public void setDeployModuleExtensions(HashMap deployExtensions) {
        this.deployModuleExtensions = deployExtensions;
    }

    public List getDeployModuleExtensions(EObject module, IRuntime runtime) {
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)module);
        return this.getDeployModuleExtensions(comp.getProject(), runtime);
    }

    public List getDeployModuleExtensions(IProject project, IRuntime runtime) {
        String typeID = "";
        if (JavaEEProjectUtilities.isEARProject(project)) {
            typeID = "jst.ear";
        } else if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
            typeID = "jst.appclient";
        } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            typeID = "jst.web";
        } else if (JavaEEProjectUtilities.isStaticWebProject(project)) {
            typeID = "wst.web";
        } else if (JavaEEProjectUtilities.isEJBProject(project)) {
            typeID = "jst.ejb";
        } else if (JavaEEProjectUtilities.isJCAProject(project)) {
            typeID = "jst.connector";
        } else if (JavaEEProjectUtilities.isUtilityProject(project)) {
            typeID = "jst.utility";
        }
        String runtimeID = null;
        runtimeID = runtime == null ? "None" : runtime.getRuntimeType().getId();
        List deployers = this.getDeployers(typeID, runtimeID);
        return this.getFilteredDeployers(project, deployers);
    }

    private List getFilteredDeployers(IProject project, List deployers) {
        IFacetedProject fProj = null;
        try {
            fProj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        if (fProj == null) {
            return deployers;
        }
        ArrayList<IConfigurationElement> filteredDeployers = new ArrayList<IConfigurationElement>();
        Iterator iterator = deployers.iterator();
        while (iterator.hasNext()) {
            boolean excludeDeployer = false;
            IConfigurationElement deployer = (IConfigurationElement)iterator.next();
            List exclusions = this.getFacetExceptions(deployer);
            if (exclusions.isEmpty()) {
                filteredDeployers.add(deployer);
                continue;
            }
            for (String exclusion : exclusions) {
                IProjectFacet facet = null;
                try {
                    facet = ProjectFacetsManager.getProjectFacet((String)exclusion);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (facet == null || !fProj.hasProjectFacet(facet)) continue;
                excludeDeployer = true;
            }
            if (excludeDeployer) continue;
            filteredDeployers.add(deployer);
        }
        return filteredDeployers;
    }

    private List getFacetExceptions(IConfigurationElement deployer) {
        if (this.facetExceptions.get(deployer) == null) {
            this.facetExceptions.put(deployer, new ArrayList());
        }
        return (List)this.facetExceptions.get(deployer);
    }
}

