import { TextDocument } from 'vscode-languageserver-textdocument';
import { ClientCapabilities, CompletionList, Position } from 'vscode-languageserver/node';
import { Telemetry } from '../../languageserver/telemetry';
import { YamlDocuments } from '../parser/yaml-documents';
import { LanguageSettings } from '../yamlLanguageService';
import { YAMLSchemaService } from './yamlSchemaService';
export declare class YamlCompletion {
    private schemaService;
    private clientCapabilities;
    private yamlDocument;
    private readonly telemetry;
    private customTags;
    private completionEnabled;
    private configuredIndentation;
    private yamlVersion;
    private indentation;
    private supportsMarkdown;
    private disableDefaultProperties;
    constructor(schemaService: YAMLSchemaService, clientCapabilities: ClientCapabilities, yamlDocument: YamlDocuments, telemetry: Telemetry);
    configure(languageSettings: LanguageSettings): void;
    doComplete(document: TextDocument, position: Position, isKubernetes?: boolean): Promise<CompletionList>;
    private finalizeParentCompletion;
    private createTempObjNode;
    private addPropertyCompletions;
    private getValueCompletions;
    private getInsertTextForProperty;
    private getInsertTextForObject;
    private getInsertTextForArray;
    private getInsertTextForGuessedValue;
    private getInsertTextForPlainText;
    private getInsertTextForValue;
    private getInsertTemplateForValue;
    private addSchemaValueCompletions;
    private collectTypes;
    private addDefaultValueCompletions;
    private addEnumValueCompletions;
    private getLabelForValue;
    private collectDefaultSnippets;
    private getInsertTextForSnippetValue;
    private addBooleanValueCompletion;
    private addNullValueCompletion;
    private getLabelForSnippetValue;
    private getCustomTagValueCompletions;
    private addCustomTagValueCompletion;
    private getDocumentationWithMarkdownText;
    private getSuggestionKind;
    private getCurrentWord;
    private fromMarkup;
    private doesSupportMarkdown;
    private findItemAtOffset;
}
