/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AttributesProvider;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;

public final class CategoryInfo
extends AbstractElementInfo {
    private final List<EntryInfo> m_entries = Lists.newArrayList();
    private boolean m_open;
    private boolean m_optional;

    public CategoryInfo() {
    }

    public CategoryInfo(String id) {
        this.setId(id);
    }

    public CategoryInfo(AttributesProvider attributes) {
        String id = attributes.getAttribute("id");
        Assert.isNotNull((Object)id);
        this.setId(id);
        String name = attributes.getAttribute("name");
        Assert.isNotNull((Object)name);
        this.setName(name);
        this.setDescription(attributes.getAttribute("description"));
        this.setVisible(CategoryInfo.getBoolean(attributes, "visible", true));
        this.setOpen(CategoryInfo.getBoolean(attributes, "open", true));
        this.m_optional = CategoryInfo.getBoolean(attributes, "optional", false);
    }

    public String toString() {
        return "Category(id='" + this.getId() + "', name='" + this.getName() + "', entries=" + this.m_entries + ")";
    }

    public List<EntryInfo> getEntries() {
        return this.m_entries;
    }

    public void addEntry(EntryInfo entry) {
        this.addEntry(this.m_entries.size(), entry);
    }

    public void addEntry(int index, EntryInfo entry) {
        this.m_entries.add(index, entry);
        entry.setCategory(this);
    }

    public void removeEntry(EntryInfo entry) {
        this.m_entries.remove(entry);
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void setOpen(boolean open) {
        this.m_open = open;
    }

    public boolean isOptional() {
        return this.m_optional;
    }
}

