/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "calc.h"


void buf_init();
std::string*getString(char*str);
int arry(char*buff,const char*str);
int calculation_(char*str);
void substitution_(char*str);

static char buf[MAX_STR_LEN];
static char str_buf[MAX_STR_LEN];
static char str_buf2[MAX_STR_LEN];


//Oobt@
static std::string*stringBuf[STRING_RING_BUF];
static int str_ring_ptr;

//Oobt@̏ _Iɂ͕KvȂ
void buf_init(){
	str_ring_ptr=0;
}
//Oobt@std::string擾
std::string*getString(char*str){
	if((STRING_RING_BUF-1)<str_ring_ptr) str_ring_ptr=0;
	while(NULL==stringBuf[str_ring_ptr]) stringBuf[str_ring_ptr]=new std::string();
	*stringBuf[str_ring_ptr]=str;
	return stringBuf[str_ring_ptr++];
}



//g[NƂɐ؂o
void token(char*str,std::vector<std::string*>*data){
	char pos;
	std::string*strpos=getString("");
	while(pos=*str++){
		switch (pos){
		case '\"':
			*strpos=*strpos+pos;
			pos=*str++;
			while('\"'!=pos && '\0'!=pos){
#ifdef SHIFT_JIS
				//VtgJIS̓ǂݍ
				if((0x81<=(unsigned char)pos && 0x9F>=(unsigned char)pos) || (0xE0<=(unsigned char)pos && 0xFC>=(unsigned char)pos)){
					*strpos=*strpos+pos;
					pos=*str++;
					if('\0'==pos){return;}//vIȃG[
					*strpos=*strpos+pos;
					pos=*str++;
				}else 
#endif
				if('\\'==pos){//GXP[vV[PX̓ǂݍ
					//*strpos=*strpos+pos;
					pos=*str++;
					if('\0'==pos){return;}//vIȃG[
					if('n'==pos) pos='\n';
					*strpos=*strpos+pos;
					pos=*str++;
				}else
				
				{
					*strpos=*strpos+pos;
					pos=*str++;//""ň͂܂ꂽǂݔ΂
				}
			}
			//͐擪"̂ƍl
			*strpos=*strpos+pos;
			break;
		case '[':
			//z̒g͓ǂݔ΂
			*strpos=*strpos+pos;
			pos=*str++;
			while(']'!=pos){
					*strpos=*strpos+pos;
					pos=*str++;//͂܂ꂽǂݔ΂
					if('\0'==pos){return;}//vIȃG[
			}
			*strpos=*strpos+pos;
			break;
		case '+':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("+"));
			break;
		case '-':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("-"));
			break;
		case '*':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("*"));
			break;
		case '/':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("/"));
			break;
		case '(':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("("));
			break;
		case ')':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString(")"));
			break;
//------------------------------------------------
		case '=':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			data->push_back(getString("="));
			break;
		case '<':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			if('='==*(str)){
				data->push_back(getString("<="));
				str++;
			}else if('>'==*(str)){
				data->push_back(getString("<>"));
				str++;
			}else{
				data->push_back(getString("<"));
			}
			break;
		case '>':
			if(*strpos!="") data->push_back(strpos);
			strpos=getString("");
			if('='==*(str)){
				data->push_back(getString(">="));
				str++;
			}else{
				data->push_back(getString(">"));
			}
			break;
		case '&':
			if(0==strncmp((str-1),"&&",sizeof("&&")-1)){
				str++;
				if(*strpos!="") data->push_back(strpos);
				strpos=getString("");
				data->push_back(getString("&&"));
				break;
			}
		case '|':
			if(0==strncmp((str-1),"||",sizeof("||")-1)){
				str++;
				if(*strpos!="") data->push_back(strpos);
				strpos=getString("");
				data->push_back(getString("||"));
				break;
			}
//------------------------------------------------
		default:
			*strpos=*strpos+pos;
			break;
		}
	}
	if(*strpos!="") data->push_back(strpos);
}

//g[Nł邩mF
bool isToken(std::string*str){
	if(
		*str=="+" || *str=="-" || *str=="*" || *str=="/" || *str=="=" || *str=="<" ||
		*str=="<=" || *str==">" || *str==">=" || *str=="&&" || *str=="||" || *str=="<>"
		) return true;
	return false;
}

//g[N̐`
void tokenAna(std::vector<std::string*>*in,std::vector<std::string*>*out){
	if(isToken((*in)[0])){
		*(*in)[1]=*(*in)[0]+*(*in)[1];
	}else{
		out->push_back((*in)[0]);
	}

	for(int i=1;(unsigned int)i<in->size();i++) {
		if(isToken((*in)[i])){
			if(isToken((*in)[i-1])){
				*(*in)[i+1]=*(*in)[i]+*(*in)[i+1];
			}else{
				if(*(*in)[i-1]=="("){
					*(*in)[i+1]=*(*in)[i]+*(*in)[i+1];
				}else{
					out->push_back((*in)[i]);
				}
			}
		}else{
			out->push_back((*in)[i]);
		}
	}
}



//t|[h@ɕϊ邽߂̉Zq̗D揇ʂ
int Priority(const char*str){
	if(0==strcmp(str,"=")) return 5;
	if(0==strcmp(str,"<")) return 5;
	if(0==strcmp(str,"<=")) return 5;
	if(0==strcmp(str,">")) return 5;
	if(0==strcmp(str,">=")) return 5;
	if(0==strcmp(str,"<>")) return 5;
	if(0==strcmp(str,"&&")) return 4;
	if(0==strcmp(str,"||")) return 4;

	if(0==strcmp(str,"+")) return 10;
	if(0==strcmp(str,"-")) return 10;
	if(0==strcmp(str,"*")) return 20;
	if(0==strcmp(str,"/")) return 25;
	return 0;
}

//t|[h@ɕϊ
void Analyzer(std::vector<std::string*>*data,std::vector<std::string*>*out,int*i){
	std::stack<const char*> stack;

	for(;(unsigned int)*i<data->size();(*i)++){
		if( *(*data)[*i]=="+" || *(*data)[*i]=="-" || *(*data)[*i]=="*" || *(*data)[*i]=="/" ||
			*(*data)[*i]=="=" || *(*data)[*i]=="<" || *(*data)[*i]=="<="|| *(*data)[*i]==">" ||
			*(*data)[*i]==">="|| *(*data)[*i]=="<>"|| *(*data)[*i]=="||"|| *(*data)[*i]=="&&"
			){
			if(stack.empty()==false){//false : X^bNɒl
				if(Priority((*data)[*i]->c_str())==Priority(stack.top())){
					stack.push((*data)[*i]->c_str());//l̒ǉ
				}
				if(Priority((*data)[*i]->c_str())<Priority(stack.top())){
					while(stack.empty()==false){//false : X^bNɒl
						const char*str=stack.top();//Ō̒l̎擾
						stack.pop();//Ō̒l̍폜
						out->push_back(getString((char*)str));
					}
					stack.push((*data)[*i]->c_str());//l̒ǉ
				}
				if(Priority((*data)[*i]->c_str())>Priority(stack.top())){
					stack.push((*data)[*i]->c_str());//l̒ǉ
				}
			}else{
				stack.push((*data)[*i]->c_str());//l̒ǉ
			}
		}else{
			if(*(*data)[*i]=="("){
				*i=*i+1;
				Analyzer(data,out,i);
			}else{
				if(*(*data)[*i]==")"){
					goto end;
				}else{
					out->push_back((*data)[*i]);
				}
			}
		}
	}
end:
	while(stack.empty()==false){//false : X^bNɒl
		const char*str=stack.top();//Ō̒l̎擾
		stack.pop();//Ō̒l̍폜
		out->push_back(getString((char*)str));
	}
}


//t|[h@\ĽvZvZ
VARIANT_*calc(std::vector<std::string*>*out){
	int c=(int)(out->size());
	VARIANT_ *j,*k;
	for(int i=0;i<c;i++){
			if(*(*out)[i]== "+"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)+j);
			}else if(*(*out)[i]=="-"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)-j);
			}else if(*(*out)[i]=="*"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)*j);
			}else if(*(*out)[i]=="/"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)/j);
//----------------------------------------------------
			}else if(*(*out)[i]=="="){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)==j);
			}else if(*(*out)[i]=="<"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)<j);
			}else if(*(*out)[i]=="<="){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)<=j);
			}else if(*(*out)[i]==">"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)>j);
			}else if(*(*out)[i]==">="){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)>=j);
			}else if(*(*out)[i]=="<>"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)!=j);
			}else if(*(*out)[i]=="&&"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k) && j);
			}else if(*(*out)[i]=="||"){
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)||j);
//-----------------------------------------------------

			}else{
				char*c;
				c=getValueB((char*)(*out)[i]->c_str());//ϐlɕϊsĂ
				vari_push(c);
			}
		}
		j=vari_top();
		vari_pop();
	return j;
}


//vZvZĕϐe[uɊi[+z̏
//߂l@vZKv:1 ̂:0
int calculation(char*str){
	buf_init();//Oobt@̏
	arry(buf,(const char*)str);
	return calculation_(buf);
}
//vZvZĕϐe[uɊi[
//߂l@vZKv:1 ̂:0
int calculation_(char*str){
	int r=0;
	char*st_ptr=strstr((const char*)str,"=");
	if(NULL!=st_ptr){
		*st_ptr++='\0';
		std::vector<std::string*> data;
		std::vector<std::string*> out;

		token(st_ptr,&data);

		std::vector<std::string*> data2;
		tokenAna(&data,&data2);

		r=(int)data2.size();
		//{printf("\ng[N؂o %d : ",data2.size());for(int a=0;a<data2.size();a++) printf("%s ",data2[a].c_str());}
		
		int c=0;
		Analyzer(&data2,&out,&c);

		//{printf("\nt|[h@ɕϊ : ");for(int a=0;a<out.size();a++) printf("%s ",out[a].c_str());}

		str_print_(calc(&out),str_buf);

		setVariable(str,str_buf);
	}
	if(r<2){
		return 0;
	}else{
		return 1;
	}
}


//݂̂̌vZ+z̏
void substitution(char*str){
	buf_init();//Oobt@̏
	arry(buf,(const char*)str);
	substitution_(buf);
}
//݂̂̌vZ
void substitution_(char*str){
	char*ptr=str;
	while('='!=*str) str++;
	*str++='\0';
	//̏ꍇ̂ݕϊs
	if('\"'==*str){
		char*pos=str_buf;
		*pos=*str;
		while(*str){
#ifdef SHIFT_JIS
			//VtgJIS̓ǂݍ
			if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
				*pos++=*str++;
				if('\0'==*str){*pos='\0';break;}//vIȃG[
				*pos++=*str++;
				if('\0'==*str){*pos='\0';break;}//vIȃG[
			}else 
#endif
			if('\\'==*str){//GXP[vV[PX̓ǂݍ
				*pos=*++str;
				if('\0'==*str){*pos='\0';break;}//vIȃG[
				if('n'==*str) *pos='\n';
				pos++;
				str++;
			}else{
				*pos++=*str++;
			}
		}
		*pos='\0';
		setVariable(ptr,getValueB(str_buf));
	}else{
		setVariable(ptr,getValueB(str));
	}
}


//z܂񂾌vZ̔zJbRvZ̌vZɂ
int arry(char*buff,const char*str){
	int resolt=0;//sꂽԂtO
	char*buff_ptr;
	char*str_buf_ptr;
	while(*str){
		//""ň͂܂Ă镔͖
		switch(*str){
			case '\"':
				while(*buff++=*str++){
					if(*str=='\"'){
						*buff++=*str++;
						break;
					}
#ifdef SHIFT_JIS
					//VtgJIS̓ǂݍ
					if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
						*buff++=*str++;
					}else 
#endif
					if(*str=='\\'){//GXP[vV[PX̓ǂݍ
						*buff++=*str++;
					}
				}
				break;
			case '[':
				*buff++=*str++;//[Rs[
				buff_ptr=str_buf2;
				_strcpy(buff_ptr,"[=");//擪Ɂ@[=@ǉ
				buff_ptr+=sizeof("[=")-1;
				for(int i=0;i<MAX_STR_LEN;i++){
					if(*str!=']'){
						*buff_ptr++=*str++;
					}else{
						*buff_ptr='\0';
						break;
					}
				}
				trim_a(str_buf2);
				calculation_(str_buf2);
				resolt=1;//sꂽ1
				str_buf_ptr=str_buf;
				_strcpy(str_buf_ptr,getVariable("["));
				//vZʂ񂾂ꍇA擪̃_uNI[e[V폜
				if('\"'==*str_buf_ptr) str_buf_ptr++;
				*buff++='\"';
				while(*buff++=*str_buf_ptr++);
				buff--;
				*buff++='\"';
				break;
			default:
				*buff++=*str++;
		}
	}
	*buff='\0';
	return resolt;
}


//-------------------------------------------------------------------------------
