/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "variant_io.h"

void vari_push(VARIANT_*ptr);
void vari_push(char*ptr);
void vari_pop();
VARIANT_*vari_top();


static char str_buf[MAX_STR_LEN];

//oAgϐ̃X^bN
//oAgϐ̃X^bÑ|C^
static int vari_buf_ptr;
//oAgϐ̃X^bÑobt@
VARIANT_*ar[VARI_BUF_SIZE];

//oAgϐvbV
void vari_push(VARIANT_*ptr){
	vari_buf_ptr++;
	while(NULL==ar[vari_buf_ptr]) ar[vari_buf_ptr]=new VARIANT_();
	*ar[vari_buf_ptr]=ptr;
	if(VARI_BUF_SIZE<vari_buf_ptr) printf("%s\n","VARIANT STACK ERR 1");
}

//ϐvbV
void vari_push(char*ptr){
	vari_buf_ptr++;
	while(NULL==ar[vari_buf_ptr]) ar[vari_buf_ptr]=new VARIANT_();
	*ar[vari_buf_ptr]=ptr;
	if(VARI_BUF_SIZE<vari_buf_ptr) printf("%s\n","VARIANT STACK ERR 2");
}

//|bv
void vari_pop(){
//	printf("pop\n");
	if(0>vari_buf_ptr) printf("%s\n","VARIANT STACK ERR 3");
	vari_buf_ptr--;
}

//X^bN̐擪o
VARIANT_*vari_top(){
	return ar[vari_buf_ptr];
}


void str_print_(VARIANT_*obj,char*str){
	if(obj->flag){
		//l^̏o
		sprintf(str,"%.13g",obj->d_val);
	}else{
		//^̏o
		_strcpy(str,obj->str_val);
	}
}

void input_(VARIANT_*obj){
	unsigned int i;
	printf("? ");
	for(i=0;i<MAX_STR_LEN-1;i++){
		char pos;
		pos=(char)getchar();
		if(pos=='\r' || pos=='\n') break;
		str_buf[i]=pos;
	}
	str_buf[i]='\0';
	*obj = str_buf;
}

static char str_buf2[MAX_STR_LEN];
//`̕ϐ͒l𕶎ŕ\ꂽlɕϊ
char*getValueB(char*str){
	double d=atof(str);
	if(0==d && '0'!=*str){
		if('\"'==*str){
			//f[^ꍇ
			_strcpy(str_buf2,str);
			//̃_uNI[e[V폜
			char*c=&str_buf2[strlen(str_buf2)-1];
			if('\"'==*c) *c='\0';
		
		}else{
			//ϐꍇ
			double pos;
			if(!strncmp(str,"time.",sizeof("time.")-1)){
				time_t now = time(NULL);
				struct tm *pnow = localtime(&now);
				if(!strcmp(str,"time.year")){
					pos=pnow->tm_year+1900;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.mon")){
					pos=pnow->tm_mon + 1;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.day")){
					pos=pnow->tm_mday;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.week")){
					pos=pnow->tm_wday;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.hour")){
					pos=pnow->tm_hour;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.min")){
					pos=pnow->tm_min;
					sprintf(str_buf2,"%.13g",pos);
				}else if(!strcmp(str,"time.sec")){
					pos=pnow->tm_sec;
					sprintf(str_buf2,"%.13g",pos);
				}
			}else if(!strcmp(str,"rand")){
				//̎QƂ̂ߗ𐶐
				pos=rand()%9999;
				sprintf(str_buf2,"%.13g",pos);
			}else{
				//ϐƍlAϐe[uQ
				if(isVariable(str)){
					char*c=getVariableConst(str);
					_strcpy(str_buf2,c);
				}else{
					sprintf(str_buf2,"0");
				}
			}
		}
	}else{
		//ꍇ
		_strcpy(str_buf2,str);
	}
	return str_buf2;
}

//-------------------------------------------------------------------------------
