/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.GrainCommon;
import com.jsyn.unitgen.GrainEnvelope;

public class RaisedCosineEnvelope
extends GrainCommon
implements GrainEnvelope {
    protected double phase;
    protected double phaseIncrement;

    public RaisedCosineEnvelope() {
        this.setFrameRate(44100.0);
        this.setDuration(0.1);
    }

    @Override
    public double next() {
        this.phase += this.phaseIncrement;
        if (this.phase > Math.PI * 2) {
            return 0.0;
        }
        return 0.5 - 0.5 * Math.cos(this.phase);
    }

    @Override
    public boolean hasMoreValues() {
        return this.phase < Math.PI * 2;
    }

    @Override
    public void reset() {
        this.phase = 0.0;
    }

    @Override
    public void setDuration(double d) {
        this.phaseIncrement = Math.PI * 2 / (this.getFrameRate() * d);
    }
}

